/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class GameEffects
implements GameConstants {
    static String[] sounds = new String[]{"/sounds/Interface/title.mid", "/sounds/Interface/menu.mid", "/sounds/Interface/levelup.mid", "/sounds/Interface/gamewin.mid", "/sounds/Interface/gamelose.mid", "/sounds/astra.mid", "/sounds/blast.mid", "/sounds/dust.mid", "/sounds/kingdie.mid"};
    static Player plyr;
    static final byte TITLE_SOUND = 0;
    static final byte MENU_SOUND = 1;
    static final byte LEVEL_UP_SOUND = 2;
    static final byte GAME_WIN_SOUND = 3;
    static final byte GAME_LOSE_SOUND = 4;
    static final byte ASTRA_SOUND = 5;
    static final byte BLAST_SOUND = 6;
    static final byte DUST_SOUND = 7;
    static final byte KING_DIE_SOUND = 8;

    public static void InitialiseSounds(String fileName) {
        try {
            InputStream is = "".getClass().getResourceAsStream(fileName);
            plyr = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            plyr.realize();
            plyr.prefetch();
        }
        catch (Exception e) {
            System.out.println(" Playing Sound    " + e);
        }
    }

    public static void playSound(String fileName, String format, int loopCount) {
        if (Abhimanyu_3D_Canvas.soundOn) {
            try {
                InputStream is = "".getClass().getResourceAsStream(fileName);
                plyr = Manager.createPlayer((InputStream)is, (String)format);
                plyr.realize();
                plyr.prefetch();
                plyr.setLoopCount(loopCount);
                plyr.start();
            }
            catch (Exception e) {
                System.out.println(" Playing Sound    " + e);
            }
        }
    }

    public static void stopSounds() {
        if (plyr != null) {
            if (plyr.getState() != 300) {
                try {
                    plyr.stop();
                    plyr.deallocate();
                    plyr.close();
                    plyr = null;
                }
                catch (Exception e) {
                    System.out.println("sound stoping error" + e);
                }
            }
        }
    }

    public static void playTitle() {
        GameEffects.playSoundDirecty(-1);
    }

    public static void playLevelUp() {
        GameEffects.playSound(sounds[2], "audio/midi", 1);
    }

    public static void playMenu() {
        GameEffects.playSound(sounds[1], "audio/midi", -1);
    }

    public static void playGameWin() {
        GameEffects.playSound(sounds[3], "audio/midi", -1);
    }

    public static void playGameLose() {
        GameEffects.playSound(sounds[4], "audio/midi", 1);
    }

    public static void playAstra() {
        GameEffects.playSound(sounds[5], "audio/midi", 1);
    }

    public static void playBlast() {
        GameEffects.playSoundDirecty(1);
    }

    public static void playDust() {
        GameEffects.playSoundDirecty(1);
    }

    public static void playSoundDirecty(int setLoopCount) {
        try {
            plyr.setLoopCount(setLoopCount);
            if (Abhimanyu_3D_Canvas.soundOn) {
                plyr.start();
            }
        }
        catch (Exception e) {
            System.out.println("Error in playSoundDirecty");
        }
    }

    public static void playKingDie() {
        GameEffects.playSound(sounds[8], "audio/midi", 1);
    }
}

