/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    static final int EXTEND_PER_ACTION = 2;
    static final int EXTEND_PER_MODULE = 4;
    static final int EXTEND_PER_SPRITE = 4;
    static final int EXTEND_PER_MECHMODULE = 4;
    static final int EXTEND_PER_COLBOX = 4;
    static final int EXTEND_PER_ATTBOX = 4;
    int m_imageID;
    byte[][] m_actions;
    byte[] m_nFrames;
    short[] m_mechModels;
    byte[] m_mechModelFlag;
    byte[][] m_frames;
    byte[] m_colBox;
    byte[] m_attBox;
    short[] m_modules;

    public void loadAnimation(DataInputStream dataInputStream) {
        try {
            int n;
            int n2 = dataInputStream.readUnsignedShort();
            this.m_imageID = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readUnsignedShort();
            this.m_modules = new short[n3 * 4];
            int n4 = 0;
            while (n4 < n3) {
                this.m_modules[4 * n4] = (short)(dataInputStream.readByte() & 0xFF);
                this.m_modules[4 * n4 + 1] = (short)(dataInputStream.readByte() & 0xFF);
                this.m_modules[4 * n4 + 2] = (short)(dataInputStream.readByte() & 0xFF);
                this.m_modules[4 * n4 + 3] = (short)(dataInputStream.readByte() & 0xFF);
                ++n4;
            }
            n3 = dataInputStream.readUnsignedShort();
            this.m_colBox = new byte[n3 * 4];
            this.m_attBox = new byte[n3 * 4];
            this.m_frames = new byte[n3][];
            int n5 = 0;
            while (n5 < n3) {
                n2 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedByte();
                this.m_frames[n5] = new byte[n * 4];
                dataInputStream.read(this.m_frames[n5], 0, n * 4);
                dataInputStream.read(this.m_colBox, n5 << 2, 4);
                dataInputStream.read(this.m_attBox, n5 << 2, 4);
                ++n5;
            }
            n3 = dataInputStream.readUnsignedShort();
            this.m_nFrames = new byte[n3];
            this.m_actions = new byte[n3][];
            this.m_mechModelFlag = new byte[n3];
            this.m_mechModels = new short[n3 * 4];
            int n6 = 0;
            while (n6 < n3) {
                n2 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedByte();
                this.m_nFrames[n6] = (byte)n;
                this.m_actions[n6] = new byte[n * 2];
                dataInputStream.read(this.m_actions[n6], 0, n * 2);
                this.m_mechModelFlag[n6] = (byte)dataInputStream.readUnsignedByte();
                n2 = (n2 - 1 - n * 2 - 1) / 2;
                int n7 = 0;
                while (n7 < n2) {
                    this.m_mechModels[n6 * 4 + n7] = (short)(dataInputStream.readShort() >> 8);
                    ++n7;
                }
                ++n6;
            }
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            System.out.println(exception + "  LOAD animation");
        }
    }

    public int[] getColBox(int n) {
        int[] nArray = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            nArray[n2] = this.m_colBox[n * 4 + n2];
            ++n2;
        }
        return nArray;
    }

    public int[] getAttBox(int n) {
        int[] nArray = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            nArray[n2] = this.m_attBox[n * 4 + n2];
            ++n2;
        }
        return nArray;
    }

    public void draw(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        byte[] byArray = this.m_frames[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < byArray.length) {
            int n7 = (byArray[n6] & 0xFF) << 2;
            int n8 = byArray[n6 + 1] & 0xFF;
            short s = this.m_modules[n7];
            short s2 = this.m_modules[n7 + 1];
            short s3 = this.m_modules[n7 + 2];
            short s4 = this.m_modules[n7 + 3];
            boolean bl = false ^ (n8 & 1) != 0;
            boolean bl2 = false ^ (n8 & 2) != 0;
            int n9 = n8 == 1 ? n + byArray[n6 + 2] * n4 - (n4 - 1) / 2 * s3 : n + byArray[n6 + 2] * n4 + (n4 - 1) / 2 * s3;
            int n10 = n2 + byArray[n6 + 3];
            if (bl && bl2 && n4 == -1) {
                n9 += 2 * s3;
            }
            short s5 = bl2 ? s4 : (short)0;
            n5 = this.trans(bl, bl2, n4);
            Animation.drawClipImage(graphics, n9 -= bl ? s3 : (short)0, n10 -= s5, image, s, s2, s3, s4, n5);
            n6 += 4;
        }
    }

    public static void drawClipImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7) {
        graphics.setClip(n, n2, n5, n6);
        if (n7 == 0) {
            graphics.setClip(n, n2, n5, n6);
            graphics.drawImage(image, n - n3, n2 - n4, 0);
        } else {
            int n8 = 0;
            switch (n7) {
                case 8192: {
                    graphics.setClip(n, n2, n5, n6);
                    n8 = 2;
                    break;
                }
                case 16384: {
                    graphics.setClip(n, n2, n5, n6);
                    n8 = 1;
                    break;
                }
                case 90: {
                    graphics.setClip(n, n2, n6, n5);
                    n8 = 5;
                    break;
                }
                case 180: {
                    graphics.setClip(n, n2, n5, n6);
                    n8 = 3;
                    break;
                }
                case 270: {
                    graphics.setClip(n, n2, n6, n5);
                    n8 = 6;
                }
            }
            graphics.drawRegion(image, n3, n4, n5, n6, n8, n, n2, 0);
        }
    }

    private int trans(boolean bl, boolean bl2, int n) {
        if (n == 1) {
            if (!bl && !bl2) {
                return 0;
            }
            if (bl && !bl2) {
                return 8192;
            }
            if (!bl && bl2) {
                return 16384;
            }
            return 180;
        }
        if (!bl && !bl2) {
            return 8192;
        }
        if (bl && !bl2) {
            return 0;
        }
        if (!bl && bl2) {
            return 180;
        }
        return 16384;
    }
}

