/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuCtl {
    MainCanvas parent;
    public static final byte SELECTIONS = 0;
    public static final byte DIALOG = 7;
    public static final byte EMBED_LIST = 14;
    public static final byte LIST = 11;
    public static final byte TEXT_BANNER = 10;
    public static final byte CONTAINER = 15;
    public byte type;
    public static final byte SHOWING = 0;
    public static final byte HIDING = 1;
    public static final byte NORMAL = 2;
    public static final byte HIDDEN = 3;
    public byte state = (byte)2;
    public static final boolean MAXIMISE_MENU_HEIGHT = false;
    public static final boolean MAXIMISE_MENU_WIDTH = false;
    public static final short BORDER_WIDTH = 8;
    public static final short BORDER_HEIGHT = 5;
    public String[] menuStrings;
    public int numSelections;
    public int menuSelectedIndex;
    Image[] circleSprite;
    Image[] menuIcons;
    public int menuX;
    public int menuY;
    public int menuWidth;
    public int menuHeight;
    public static final Font MENU_FONT = Font.getFont((int)0, (int)1, (int)8);
    public static final int MENU_FONT_BASELINE = MENU_FONT.getBaselinePosition();
    public static final int MENU_FONT_HEIGHT = MENU_FONT_BASELINE + 6;
    public short[] curAngles;
    public int curRadius;
    public int maxRadius;
    public int outerRadius;
    public int angleStep;
    public int maxAngleStep;
    public int angleSpacing;
    public int angleBaseOffset;
    public int angleRotateOffset;
    public int circleWidth;
    public int halfCircleWidth;
    public int curX;
    public int curY;
    public static final int PRECISION = 10;
    public static short[] lut = null;
    public static int FLAG = 0;
    public static int TWOPI = 360;
    public static int PI = 0;
    public static int PI2 = 0;
    public static int PI4 = 0;
    public int ignoreBorder;
    public static final byte UP = 1;
    public static final byte DOWN = 2;
    public static final byte LEFT = 4;
    public static final byte RIGHT = 8;
    public static final byte ALL = 15;
    Image[] menuSprite;
    public MenuCtl titlePanel;
    public boolean animationEnabled = true;
    public boolean needScrollBar = false;
    public int curDialogIndex;
    public int linesPerPage;
    public int textWidth;
    public int textStartX;
    public int textOffsetY;
    public int menuItemHeight;
    public int lineSpacing;
    public int halfLineSpacing;
    public String[] bannerTitles;
    public int extraBorderWidth;
    public int fadeCtr;
    public static final int MAX_FADE_COUNT = 5;
    public static final int TITLE_TEXT_COLOR = 0xFFFFFF;
    public static final int LINE_COLOR = 10463131;
    public static final int MENU_BG_COLOR = 2370117;
    public static final int TEXT_COLOR = 0xCECECE;
    public int stripColor = 2370117;
    public int panelColor = 2370117;
    public int textColor = 0xCECECE;
    public int leftAlignX = -1;
    public Vector containedMenus;
    public int activeContainedMenuIndex = -1;
    public boolean selectableInContainer;
    public boolean allMenusLinkedInContainer;
    public static final int MAX_CONTAINER_PAGES = 5;
    public int curContainerPage;
    public int lastContainerPage;
    public int[] containerPageEndY;
    public int containerPageHeight;
    Image[] buttonsSprite;
    Image[] menuArrowSprite;
    Image[] sideArrowSprite;
    public boolean doRepaint = false;
    public static final short POINTER_ANIME_DELAY = 3;
    public static final byte POINTER_BOB_LENGTH = 2;
    public int pointerOffsetX;
    public int pointerAnimeCtr;
    public short pointerAnimeDelay = (short)3;
    public static final int SEPERATOR_SPACING = 2;
    public static final int SEPERATOR_HEIGHT = 5;
    public int rectStep;
    public int dismissTime = -1;
    public static final byte CONFIRM_ACTION = 0;
    public static final byte BACK_ACTION = 1;
    public static final byte LEFT_ACTION = 2;
    public static final byte RIGHT_ACTION = 3;
    public boolean[] actionEnabled = new boolean[]{false, false};
    public static int CONFIRM_SOFTKEY = -21;
    public static int CANCEL_SOFTKEY = -22;
    public Image attachedImage;
    public Image portraitSprite;
    public byte portraitFrame = (byte)-1;

    public MenuCtl(MainCanvas mainCanvas, byte by, int n) {
        int n2;
        this.parent = mainCanvas;
        this.type = by;
        this.ignoreBorder = n;
        MenuCtl.initSinCos();
        this.circleSprite = new Image[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.circleSprite[n2] = mainCanvas.parent.LoadImage("/big_circle_0" + n2 + ".png");
        }
        this.menuSprite = new Image[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.menuSprite[n2] = mainCanvas.parent.LoadImage("/menu_0" + n2 + ".png");
        }
        this.buttonsSprite = new Image[4];
        for (n2 = 0; n2 < 4; ++n2) {
            this.buttonsSprite[n2] = mainCanvas.parent.LoadImage("/buttons" + n2 + ".png");
        }
        this.menuArrowSprite = new Image[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.menuArrowSprite[n2] = mainCanvas.parent.LoadImage("/arrow" + n2 + ".png");
        }
        this.sideArrowSprite = new Image[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.sideArrowSprite[n2] = mainCanvas.parent.LoadImage("/side_arrow_" + n2 + ".png");
        }
        this.portraitSprite = mainCanvas.parent.LoadImage("/portraits.png");
        this.attachedImage = mainCanvas.parent.LoadImage("/portraits.png");
        if (by == 15) {
            this.containerPageHeight = mainCanvas.CanvasHeight - this.buttonsSprite[0].getHeight();
            this.animationEnabled = true;
        } else if (by == 0 || by == 11) {
            this.actionEnabled[0] = true;
            this.actionEnabled[1] = true;
        }
        this.doRepaint = true;
    }

    public void initMainMenu(String[] stringArray, Image[] imageArray, int n, int n2, int n3, int n4) {
        int n5;
        this.menuStrings = stringArray;
        this.menuIcons = imageArray;
        this.menuSelectedIndex = 0;
        this.numSelections = this.menuStrings.length;
        this.lineSpacing = MENU_FONT_HEIGHT - MENU_FONT_BASELINE;
        this.curAngles = new short[this.numSelections];
        this.angleSpacing = 360 / this.numSelections;
        this.angleStep = this.maxAngleStep = this.angleSpacing / 2;
        for (n5 = 0; n5 < this.numSelections; ++n5) {
            this.curAngles[n5] = (short)(this.angleSpacing * n5);
        }
        if (this.numSelections == 1) {
            this.maxRadius = 0;
        } else if (n3 <= 0) {
            this.maxRadius = (this.circleSprite[0].getWidth() << 10) / (2 * MenuCtl.sin(45));
            this.outerRadius = this.maxRadius + this.circleSprite[0].getWidth() / 2;
            n3 = this.outerRadius * 2 + MENU_FONT_HEIGHT + 2;
        } else {
            n5 = (this.circleSprite[0].getWidth() << 10) / MenuCtl.sin(this.angleSpacing / 2) + this.circleSprite[0].getHeight() / 2;
            this.outerRadius = (n3 - MENU_FONT_HEIGHT) / 2 - 2;
            if (this.outerRadius > n5) {
                this.outerRadius = n5;
            }
            this.maxRadius = this.outerRadius - this.circleSprite[0].getHeight() / 2;
        }
        this.curRadius = 0;
        this.menuWidth = this.outerRadius * 2;
        this.menuHeight = n3;
        this.state = 0;
        this.setPosition(n, n2, n4);
    }

    public void initDialog(String string, int n, int n2, byte by) {
        this.portraitFrame = by;
        if (by == -1) {
            this.ignoreBorder = 14;
        } else {
            this.textStartX = this.portraitSprite.getWidth() - 8;
        }
        int n3 = n - this.textStartX - 16;
        this.menuStrings = MenuCtl.getStrings(string, n3, MENU_FONT);
        this.initTextBox(null, this.menuStrings, n, n2);
        this.needScrollBar = false;
        this.type = (byte)7;
    }

    public void initEmbedList(String[] stringArray, int n, int n2) {
        this.menuStrings = stringArray;
        this.numSelections = this.menuStrings.length;
        this.selectableInContainer = true;
        this.animationEnabled = false;
        this.menuHeight = n2;
        int n3 = 0;
        for (int i = 0; i < this.menuStrings.length; ++i) {
            int n4 = MENU_FONT.stringWidth(this.menuStrings[i]);
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.menuWidth = n3 + 16 + this.sideArrowSprite[0].getWidth() * 2;
        if (this.menuWidth < n) {
            this.menuWidth = n;
        }
        if (this.menuHeight < 0) {
            this.menuHeight = MENU_FONT_HEIGHT;
            if (this.sideArrowSprite[0].getHeight() > this.menuHeight) {
                this.menuHeight = this.sideArrowSprite[0].getHeight();
            }
            if ((this.ignoreBorder & 1) == 0) {
                this.menuHeight += 5;
            }
            if ((this.ignoreBorder & 2) == 0) {
                this.menuHeight += 5;
            }
        }
        this.type = (byte)14;
        this.state = (byte)2;
    }

    public void initTextList(String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.menuStrings = stringArray;
        this.numSelections = this.menuStrings.length;
        this.lineSpacing = MENU_FONT_HEIGHT - MENU_FONT_BASELINE;
        this.menuItemHeight = MENU_FONT_HEIGHT;
        int n7 = 0;
        for (int i = 0; i < this.menuStrings.length; ++i) {
            int n8 = MENU_FONT.stringWidth(this.menuStrings[i]);
            if (n8 <= n7) continue;
            n7 = n8;
        }
        this.menuWidth = n7 + 4 + 16;
        if (this.menuWidth > this.parent.CanvasWidth) {
            this.menuWidth = this.parent.CanvasWidth;
        } else if (this.menuWidth < n3) {
            if (n6 == 4) {
                this.leftAlignX = (n3 - this.menuWidth) / 2;
            }
            this.menuWidth = n3;
        }
        this.menuHeight = this.menuItemHeight * this.menuStrings.length + this.lineSpacing + 16;
        if (this.menuHeight > n4) {
            this.menuHeight = n4;
        }
        this.initTextBox(null, this.menuStrings, this.menuWidth, this.menuHeight);
        if (this.menuWidth < this.parent.CanvasWidth && this.needScrollBar) {
            this.menuWidth += this.menuArrowSprite[0].getWidth();
        }
        this.type = (byte)11;
        this.setPosition(n, n2, n5);
    }

    public void initTextBox(String string, String string2, int n, int n2) {
        int n3 = n - this.textStartX;
        if ((this.ignoreBorder & 4) == 0) {
            n3 -= 8;
        }
        if ((this.ignoreBorder & 8) == 0) {
            n3 -= 8;
        }
        this.menuStrings = MenuCtl.getStrings(string2, n3, MENU_FONT);
        this.initTextBox(string, this.menuStrings, n, n2);
        if (this.needScrollBar) {
            this.menuStrings = MenuCtl.getStrings(string2, n3 -= this.menuArrowSprite[0].getWidth(), MENU_FONT);
            this.initTextBox(string, this.menuStrings, n, n2);
        }
    }

    public void initTextBox(String string, String[] stringArray, int n, int n2) {
        this.animationEnabled = false;
        this.menuWidth = n;
        this.menuHeight = n2;
        this.numSelections = stringArray.length;
        this.menuSelectedIndex = 0;
        this.curDialogIndex = 0;
        this.textOffsetY = 0;
        this.needScrollBar = false;
        int n3 = n - this.textStartX - 16;
        if (string != null) {
            this.bannerTitles = MenuCtl.getStrings(string, n3, MENU_FONT);
        }
        this.menuStrings = stringArray;
        this.menuItemHeight = MENU_FONT_HEIGHT;
        this.lineSpacing = MENU_FONT_HEIGHT - MENU_FONT_BASELINE;
        this.halfLineSpacing = this.lineSpacing / 2;
        int n4 = n2 <= 0 ? this.parent.CanvasHeight : n2;
        if ((this.ignoreBorder & 1) == 0) {
            n4 -= 5;
        }
        if ((this.ignoreBorder & 2) == 0) {
            n4 -= 5;
        }
        if (string != null) {
            n4 -= this.bannerTitles.length * this.menuItemHeight;
        }
        this.linesPerPage = (n4 - 2) / this.menuItemHeight;
        if (this.linesPerPage > this.menuStrings.length) {
            this.linesPerPage = this.menuStrings.length;
        } else if (this.linesPerPage < this.menuStrings.length) {
            this.needScrollBar = true;
        }
        if (n2 < 0) {
            if (this.bannerTitles != null) {
                this.menuHeight = this.bannerTitles.length * this.menuItemHeight;
            }
            this.menuHeight += this.linesPerPage * this.menuItemHeight;
            if ((this.ignoreBorder & 1) == 0) {
                this.menuHeight += 5;
            }
            if ((this.ignoreBorder & 2) == 0) {
                this.menuHeight += 5;
            }
            this.menuHeight += 2;
            this.extraBorderWidth = 1;
        } else {
            this.extraBorderWidth = (n4 - this.linesPerPage * this.menuItemHeight) / 2;
        }
        this.type = (byte)10;
        this.state = (byte)2;
    }

    public MenuCtl createTitlePanel(String string) {
        this.titlePanel = new MenuCtl(this.parent, 10, 0);
        this.titlePanel.initTextBox(null, string, this.parent.CanvasWidth, -1);
        return this.titlePanel;
    }

    public void addMenuToContainer(MenuCtl menuCtl, int n, int n2, int n3) {
        int n4;
        if (this.containedMenus == null) {
            this.containedMenus = new Vector();
        }
        if (this.containerPageEndY == null) {
            this.containerPageEndY = new int[5];
            for (n4 = 0; n4 < 5; ++n4) {
                this.containerPageEndY[n4] = this.containerPageHeight;
                if (n4 <= 0) continue;
                int n5 = n4;
                this.containerPageEndY[n5] = this.containerPageEndY[n5] - this.buttonsSprite[0].getHeight();
            }
        }
        menuCtl.setPosition(n, n2, n3);
        n4 = menuCtl.menuY;
        for (int i = 0; i < 5; ++i) {
            if (n4 < this.containerPageEndY[i]) {
                if (n4 + menuCtl.menuHeight <= this.containerPageEndY[i]) break;
                this.containerPageEndY[i] = n4;
                if (i + 1 <= this.lastContainerPage) break;
                this.lastContainerPage = i + 1;
                break;
            }
            n4 -= this.containerPageEndY[i];
        }
        menuCtl.setMenuAction((byte)0, false);
        menuCtl.setMenuAction((byte)1, false);
        this.containedMenus.addElement(menuCtl);
    }

    private void setPosition(int n, int n2, int n3) {
        this.menuX = n;
        this.menuY = n2;
        if ((n3 & 1) != 0) {
            this.menuX -= this.menuWidth >> 1;
        } else if ((n3 & 8) != 0) {
            this.menuX -= this.menuWidth;
        }
        if ((n3 & 2) != 0) {
            this.menuY -= this.menuHeight >> 1;
        } else if ((n3 & 0x20) != 0) {
            this.menuY -= this.menuHeight;
        }
        this.curX = this.menuX;
        this.curY = this.menuY;
    }

    public void tick() throws Exception {
        this.tick(true);
    }

    public void tick(boolean bl) throws Exception {
        int n;
        if (this.state == 3) {
            return;
        }
        if (this.type == 10 && this.dismissTime > 0 && this.dismissTime <= 250) {
            ++this.fadeCtr;
            this.doRepaint = true;
        } else if (this.fadeCtr > 0) {
            --this.fadeCtr;
            this.doRepaint = true;
        }
        if (bl && this.state == 2) {
            if (this.type == 15) {
                if (!this.allMenusLinkedInContainer && this.activeContainedMenuIndex >= 0) {
                    int n2;
                    int n3;
                    MenuCtl menuCtl;
                    if (this.parent.menuKeyBuffer == 1) {
                        ((MenuCtl)this.containedMenus.elementAt((int)this.activeContainedMenuIndex)).doRepaint = true;
                        this.activeContainedMenuIndex = this.getNextSelectableContainedMenu(-1);
                        menuCtl = (MenuCtl)this.containedMenus.elementAt(this.activeContainedMenuIndex);
                        menuCtl.doRepaint = true;
                        n3 = menuCtl.menuY;
                        for (n2 = 0; n2 < 5; ++n2) {
                            if (n3 < this.containerPageEndY[n2]) {
                                if (this.curContainerPage == n2) break;
                                this.showNotify();
                                this.curContainerPage = n2;
                                break;
                            }
                            n3 -= this.containerPageEndY[n2];
                        }
                    } else if (this.parent.menuKeyBuffer == 6) {
                        ((MenuCtl)this.containedMenus.elementAt((int)this.activeContainedMenuIndex)).doRepaint = true;
                        this.activeContainedMenuIndex = this.getNextSelectableContainedMenu(1);
                        menuCtl = (MenuCtl)this.containedMenus.elementAt(this.activeContainedMenuIndex);
                        menuCtl.doRepaint = true;
                        n3 = menuCtl.menuY;
                        for (n2 = 0; n2 < 5; ++n2) {
                            if (n3 < this.containerPageEndY[n2]) {
                                if (this.curContainerPage == n2) break;
                                this.showNotify();
                                this.curContainerPage = n2;
                                break;
                            }
                            n3 -= this.containerPageEndY[n2];
                        }
                    }
                }
                for (n = 0; n < this.containedMenus.size(); ++n) {
                    MenuCtl menuCtl = (MenuCtl)this.containedMenus.elementAt(n);
                    if (this.allMenusLinkedInContainer) {
                        menuCtl.tick(true);
                        continue;
                    }
                    menuCtl.tick(n == this.activeContainedMenuIndex);
                }
                this.doRepaint = true;
            } else if (this.type == 0 && this.state == 2) {
                this.doRepaint = true;
                if (this.parent.menuKeyBuffer == -2 || this.parent.menuKeyBuffer == 52) {
                    this.parent.menuKeyBuffer = 0;
                    this.angleRotateOffset -= this.angleSpacing;
                    this.angleBaseOffset += this.angleSpacing;
                    --this.menuSelectedIndex;
                    if (this.menuSelectedIndex < 0) {
                        this.menuSelectedIndex = this.numSelections - 1;
                    }
                } else if (this.parent.menuKeyBuffer == -5 || this.parent.menuKeyBuffer == 54) {
                    this.parent.menuKeyBuffer = 0;
                    this.angleRotateOffset += this.angleSpacing;
                    this.angleBaseOffset -= this.angleSpacing;
                    if (this.angleBaseOffset < 0) {
                        this.angleBaseOffset += 360;
                    }
                    ++this.menuSelectedIndex;
                    if (this.menuSelectedIndex >= this.numSelections) {
                        this.menuSelectedIndex = 0;
                    }
                }
                if (this.angleRotateOffset != 0) {
                    n = -this.angleRotateOffset / 2;
                    this.angleRotateOffset = n == 0 ? 0 : (this.angleRotateOffset += n);
                }
            }
        }
        if (this.animationEnabled && ++this.pointerAnimeCtr >= this.pointerAnimeDelay) {
            this.pointerOffsetX = this.pointerOffsetX == 0 ? 2 : 0;
            this.pointerAnimeCtr = 0;
            this.doRepaint = true;
        }
        switch (this.state) {
            case 0: {
                if (this.type == 0) {
                    if (this.curRadius < this.maxRadius) {
                        n = this.maxRadius / 5;
                        if (n < 1) {
                            n = 1;
                        }
                        this.curRadius += n;
                        if (this.curRadius > this.maxRadius) {
                            this.curRadius = this.maxRadius;
                        }
                    } else {
                        this.angleStep = Math.abs(360 - this.curAngles[0]) / 2;
                        if (this.angleStep < 1) {
                            this.angleStep = 1;
                        } else if (this.angleStep > this.maxAngleStep) {
                            this.angleStep = this.maxAngleStep;
                        }
                    }
                    for (n = 0; n < this.curAngles.length; ++n) {
                        this.curAngles[n] = (short)((this.curAngles[n] + this.angleStep) % 360);
                    }
                    if (this.curRadius >= this.maxRadius && this.curAngles[0] == 0) {
                        this.curRadius = this.maxRadius;
                        for (n = 0; n < this.curAngles.length; ++n) {
                            this.curAngles[n] = (short)(this.angleSpacing * n);
                        }
                        this.state = (byte)2;
                        this.parent.resetKeys();
                    }
                    MainCanvas.menuflag = 0;
                } else {
                    n = (this.menuX - this.curX) / 4;
                    if (n <= 0) {
                        n = 1;
                    }
                    this.curX += n;
                    if (this.curX == this.menuX) {
                        this.state = (byte)2;
                    }
                    MainCanvas.menuflag = 0;
                }
                this.doRepaint = true;
                break;
            }
            case 1: {
                this.state = (byte)3;
            }
        }
        this.parent.menuKeyBuffer = 0;
    }

    public void paintScreen(Graphics graphics) {
        this.paintScreen(graphics, 0, 0, false);
    }

    public void paintScreen(Graphics graphics, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.state == 3) {
            return;
        }
        graphics.setClip(0, 0, this.parent.CanvasWidth, this.parent.CanvasHeight);
        if (this.titlePanel != null) {
            this.titlePanel.paintScreen(graphics);
        }
        int n7 = this.curX + n;
        int n8 = this.curY + n2;
        int n9 = 0;
        int n10 = 0;
        if (this.type != 0) {
            this.paintMenuBackground(graphics, n7, n8, this.menuWidth, this.menuHeight, this.ignoreBorder, this.panelColor, this.stripColor, this.fadeCtr, 5);
            graphics.setClip(0, 0, this.parent.CanvasWidth, this.parent.CanvasHeight);
        }
        n9 = this.menuWidth;
        n10 = this.menuHeight;
        if ((this.ignoreBorder & 1) == 0) {
            n10 -= 5;
            n8 += 5;
        }
        if ((this.ignoreBorder & 2) == 0) {
            n10 -= 5;
        }
        if ((this.ignoreBorder & 4) == 0) {
            n7 += 8;
            n9 -= 8;
        }
        if ((this.ignoreBorder & 8) == 0) {
            n9 -= 8;
        }
        graphics.translate(n7, n8);
        graphics.setFont(MENU_FONT);
        if (this.attachedImage != null && (this.menuStrings == null || MENU_FONT.stringWidth(this.menuStrings[0]) < n9 - this.attachedImage.getWidth() * 2)) {
            graphics.drawImage(this.attachedImage, 0, n10 / 2, 6);
        }
        if (bl) {
            graphics.setColor(5594742);
            MenuCtl.drawSelectRect(graphics, 0, 0, n9, n10);
        }
        if (this.type == 0) {
            graphics.setColor(0xFFFFFF);
            n6 = this.angleBaseOffset + this.angleRotateOffset;
            for (n5 = this.curAngles.length - 1; n5 >= 0; --n5) {
                n4 = (this.curAngles[n5] + n6) % 360;
                if (n4 < 0) {
                    n4 += 360;
                }
                int n11 = this.outerRadius + (MenuCtl.sin(n4) * (this.curRadius + 10) >> 10);
                n3 = 10 + MENU_FONT_HEIGHT + this.outerRadius + 2 - (MenuCtl.cos(n4) * (this.curRadius + 10) >> 10);
                if (this.state == 2 && n5 == this.menuSelectedIndex) {
                    graphics.drawImage(this.circleSprite[1], n11, n3, 3);
                } else {
                    graphics.drawImage(this.circleSprite[0], n11, n3, 3);
                }
                if (this.menuStrings[n5] == null || this.menuIcons == null || this.menuIcons[n5] == null) continue;
                graphics.drawImage(this.menuIcons[n5], n11, n3, 3);
            }
        }
        switch (this.type) {
            case 15: {
                int n12;
                n5 = 0;
                n4 = 0;
                int n13 = this.containerPageEndY[0];
                for (n12 = 1; n12 <= this.curContainerPage; ++n12) {
                    n5 = n13;
                    n13 += this.containerPageEndY[n12];
                }
                if (this.curContainerPage > 0) {
                    n4 = -n5 + this.buttonsSprite[0].getHeight();
                }
                for (n12 = 0; n12 < this.containedMenus.size(); ++n12) {
                    MenuCtl menuCtl = (MenuCtl)this.containedMenus.elementAt(n12);
                    if (menuCtl.menuY < n5 || menuCtl.menuY >= n13) continue;
                    menuCtl.paintScreen(graphics, 0, n4, n12 == this.activeContainedMenuIndex);
                }
                graphics.setClip(0, 0, this.parent.CanvasWidth, this.parent.CanvasHeight);
                if (this.curContainerPage > 0) {
                    graphics.setColor(2370117);
                    graphics.fillRect(0, 0, this.parent.CanvasWidth, this.buttonsSprite[0].getHeight());
                    graphics.drawImage(this.menuArrowSprite[0], this.parent.CanvasWidth / 2, -this.pointerOffsetX, 17);
                }
                if (this.curContainerPage >= this.lastContainerPage) break;
                graphics.setColor(2370117);
                n12 = this.containerPageEndY[this.curContainerPage];
                if (this.curContainerPage > 0) {
                    n12 += this.buttonsSprite[0].getHeight();
                }
                graphics.fillRect(0, n12, this.parent.CanvasWidth, this.parent.CanvasHeight - n12);
                graphics.drawImage(this.menuArrowSprite[1], this.parent.CanvasWidth / 2, this.parent.CanvasHeight + this.pointerOffsetX, 33);
                break;
            }
            case 0: {
                if (this.state != 2) break;
                graphics.setColor(1645370);
                MenuCtl.drawSelectRect(graphics, 2 - this.menuX, 1, this.parent.CanvasWidth - 4, MENU_FONT_HEIGHT);
                if (this.menuStrings[this.menuSelectedIndex] == null) break;
                graphics.setColor(0xFFFFFF);
                graphics.drawString(this.menuStrings[this.menuSelectedIndex], this.outerRadius, (this.lineSpacing >> 1) + 1, 17);
                break;
            }
            case 14: {
                graphics.setFont(MENU_FONT);
                graphics.setColor(MenuCtl.getColor(0xFFFFFF, 1645370, this.fadeCtr, 5));
                n6 = n10 / 2;
                graphics.drawString(this.menuStrings[this.menuSelectedIndex], n9 / 2, (n10 - MENU_FONT_BASELINE) / 2, 17);
                graphics.drawImage(this.sideArrowSprite[0], 0, n6, 6);
                graphics.drawImage(this.sideArrowSprite[1], n9, n6, 10);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                int n14;
                int n15;
                int n16;
                int n17;
                graphics.setFont(MENU_FONT);
                if (this.portraitFrame != -1) {
                    graphics.drawImage(this.portraitSprite, -8, n10, 36);
                }
                graphics.setClip(0, 0, n9 -= this.textStartX, this.menuHeight - 10);
                int n18 = 0;
                n3 = 0;
                if (this.bannerTitles != null) {
                    graphics.setColor(MenuCtl.getColor(0xFFFFFF, this.panelColor, this.fadeCtr, 5));
                    for (n17 = 0; n17 < this.bannerTitles.length; ++n17) {
                        graphics.drawString(this.bannerTitles[n17], this.textStartX + n9 / 2, n3 + this.halfLineSpacing, 17);
                        n3 += this.menuItemHeight;
                    }
                    graphics.setColor(10463131);
                    graphics.drawLine(0, n3, n9 - 1, n3);
                    n18 = n3;
                }
                n17 = n3 + this.extraBorderWidth;
                graphics.setColor(this.textColor);
                int n19 = this.curDialogIndex;
                int n20 = this.curDialogIndex + this.linesPerPage;
                if (this.textOffsetY > 0) {
                    --n19;
                    n3 -= this.menuItemHeight;
                } else if (this.textOffsetY < 0) {
                    ++n20;
                }
                n3 += this.textOffsetY + this.extraBorderWidth;
                graphics.setClip(this.textStartX, n18, n9, n10 - n18);
                int n21 = n9;
                if (this.needScrollBar) {
                    n21 -= this.menuArrowSprite[0].getWidth();
                }
                int n22 = this.textStartX + n21 / 2;
                for (n16 = n19; n16 < n20; ++n16) {
                    n15 = 0;
                    if (n3 < n17) {
                        n15 = n17 - n3;
                    } else if (n3 + this.menuItemHeight > n10 - this.extraBorderWidth) {
                        n15 = n3 + this.menuItemHeight - n10 + this.extraBorderWidth;
                    }
                    if (this.type == 11 && n16 == this.menuSelectedIndex) {
                        graphics.setColor(5594742);
                        MenuCtl.drawSelectRect(graphics, 0, n3, n21, this.menuItemHeight);
                        n14 = MenuCtl.getColor(this.panelColor, 0xFFFFFF, this.menuItemHeight - n15, this.menuItemHeight);
                    } else {
                        n14 = MenuCtl.getColor(this.panelColor, this.textColor, this.menuItemHeight - n15, this.menuItemHeight);
                    }
                    n14 = MenuCtl.getColor(n14, this.panelColor, this.fadeCtr, 5);
                    graphics.setColor(n14);
                    if (this.leftAlignX >= 0) {
                        graphics.drawString(this.menuStrings[n16], this.leftAlignX, n3 + this.halfLineSpacing, 20);
                    } else {
                        graphics.drawString(this.menuStrings[n16], n22, n3 + this.halfLineSpacing, 17);
                    }
                    n3 += this.menuItemHeight;
                }
                if (this.needScrollBar) {
                    n16 = this.menuArrowSprite[0].getHeight();
                    n15 = this.menuArrowSprite[0].getWidth();
                    n14 = this.menuArrowSprite[0].getWidth() / 2;
                    int n23 = n10 - n16 * 2 - 2;
                    int n24 = n9 - (n15 + n14) / 2;
                    if (n23 > 2) {
                        graphics.setColor(this.textColor);
                        MenuCtl.drawSelectRect(graphics, n24, n16 + 1, n14, n23);
                        int n25 = (n23 - 2) * this.linesPerPage / this.numSelections;
                        if (n25 < 1) {
                            n25 = 1;
                        }
                        graphics.setColor(2370117);
                        MenuCtl.drawSelectRect(graphics, n24 + 1, n16 + (n23 - 2) * this.curDialogIndex / this.numSelections + 2, n14 - 2, n25);
                        graphics.drawImage(this.menuArrowSprite[0], n9 - n15, 0, 20);
                        graphics.drawImage(this.menuArrowSprite[1], n9 - n15, n10, 36);
                    } else {
                        if (this.curDialogIndex > 0) {
                            graphics.drawImage(this.menuArrowSprite[0], n9 - n15, 0, 20);
                        }
                        if (this.curDialogIndex + this.linesPerPage < this.numSelections) {
                            graphics.drawImage(this.menuArrowSprite[1], n9 - n15, n10, 36);
                        }
                    }
                }
                if (this.type != 7) break;
                graphics.setClip(0, 0, this.parent.CanvasWidth, this.parent.CanvasHeight);
                n16 = n10;
                if ((this.ignoreBorder & 2) == 0) {
                    n16 += 5;
                }
                graphics.drawImage(this.menuArrowSprite[1], n9 + this.textStartX, n16, 40);
            }
        }
        graphics.translate(-n7, -n8);
        graphics.setClip(0, 0, this.parent.CanvasWidth, this.parent.CanvasHeight);
        if (this.state == 2) {
            if (this.actionEnabled[0]) {
                this.paintSoftKey(graphics, CONFIRM_SOFTKEY, 0, this.parent.CanvasHeight);
            }
            if (this.actionEnabled[1]) {
                this.paintSoftKey(graphics, CANCEL_SOFTKEY, 1, this.parent.CanvasHeight);
            }
        }
    }

    public void paintSoftKey(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n == -21) {
            n5 = 36;
        } else if (n == -22) {
            n4 = this.parent.CanvasWidth;
            n5 = 40;
        }
        graphics.drawImage(this.buttonsSprite[n2], n4, n3, n5);
    }

    public static void drawSelectRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 <= 2) {
            graphics.fillRect(n, n2, n3, n4);
        } else {
            graphics.fillRect(n, n2 + 1, n3, n4 - 2);
            graphics.fillRect(n + 1, n2, n3 - 2, n4);
        }
    }

    public static void initSinCos() {
        int n = 1024;
        PI = TWOPI >> 1;
        PI2 = PI >> 1;
        PI4 = PI2 >> 1;
        FLAG = TWOPI - 1;
        lut = new short[TWOPI];
        int n2 = TWOPI * 10000 / 2 / 31415;
        int n3 = n * n2;
        int n4 = 0;
        for (int i = 0; i < TWOPI; ++i) {
            int n5 = n4 / n2;
            MenuCtl.lut[i] = (short)n5;
            n4 += (n3 -= n5) / n2;
        }
        MenuCtl.lut[180] = 0;
        MenuCtl.lut[270] = -1024;
    }

    public static short sin(int n) {
        return lut[n %= 360];
    }

    public static short cos(int n) {
        n = (n + PI2) % 360;
        return lut[n];
    }

    public int getNextSelectableContainedMenu(int n) {
        int n2;
        int n3 = n2 = this.activeContainedMenuIndex;
        int n4 = this.containedMenus.size();
        do {
            if ((n2 += n) < 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n2 < this.containedMenus.size()) continue;
            if (n3 < 0) {
                return -1;
            }
            n2 = 0;
        } while (!((MenuCtl)this.containedMenus.elementAt((int)n2)).selectableInContainer);
        return n2;
    }

    public static String[] getStrings(String string, int n, Font font) {
        int n2;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        boolean bl = false;
        int n4 = string.length();
        String string2 = null;
        do {
            n2 = n3;
            int n5 = string.indexOf(10, n2);
            block1: do {
                int n6 = n2;
                String string3 = string2;
                n2 = MenuCtl.getWordIndex(string, n2);
                if (n5 > -1 && n5 < n2) {
                    n2 = n5;
                }
                if (font.stringWidth(string2 = string.substring(n3, n2).trim()) <= n) continue;
                if (n6 == n3) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (font.stringWidth(string4) > n) continue;
                        n2 = n6 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n2 = n6;
                string2 = string3;
                break;
            } while (n2 != n5 && n2 < n4);
            vector.addElement(string2);
        } while ((n3 = ++n2) < n4);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (MenuCtl.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!MenuCtl.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    public static int getColor(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            return n;
        }
        if (n3 == n4) {
            return n2;
        }
        int n5 = n & 0xFF0000;
        int n6 = n & 0xFF00;
        int n7 = n & 0xFF;
        int n8 = (((n2 & 0xFF0000) - n5) * n3 / n4 & 0xFF0000) + n5;
        int n9 = (((n2 & 0xFF00) - n6) * n3 / n4 & 0xFF00) + n6;
        int n10 = ((n2 & 0xFF) - n7) * n3 / n4 + n7;
        return n8 | n9 | n10;
    }

    public static int getColor(int n, int n2, int n3) {
        int n4 = (n & 0xFF0000) * n2 / n3 & 0xFF0000;
        int n5 = (n & 0xFF00) * n2 / n3 & 0xFF00;
        int n6 = (n & 0xFF) * n2 / n3;
        return n4 | n5 | n6;
    }

    public void paintMenuBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintMenuBackground(graphics, n, n2, n3, n4, n5, 2370117, 2370117, 0, 0);
    }

    public void paintMenuBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12;
        int n13;
        graphics.clipRect(n, n2, n3, n4);
        graphics.setColor(n6);
        graphics.fillRect(n, n2, n3, n4);
        if (n7 != n6) {
            n13 = n4 / 4;
            n12 = n2 + 5;
            for (n11 = 0; n11 < n13; ++n11) {
                n10 = MenuCtl.getColor(n7, n6, n11, n13);
                graphics.setColor(MenuCtl.getColor(n10, n6, n8, n9));
                graphics.fillRect(n, n12, n3, 1);
                ++n12;
            }
        }
        if (n5 != 15) {
            int n14;
            n13 = (n5 & 4) == 0 ? 1 : 0;
            n12 = (n5 & 8) == 0 ? 1 : 0;
            n10 = (n5 & 1) == 0 ? 1 : 0;
            n11 = (n5 & 2) == 0 ? 1 : 0;
            int n15 = n3 / this.menuSprite[0].getWidth() - 2;
            if (n3 % this.menuSprite[0].getWidth() != 0) {
                ++n15;
            }
            if (n13 == 0) {
                ++n15;
            }
            if (n12 == 0) {
                ++n15;
            }
            int n16 = n4 / this.menuSprite[0].getHeight() - 2;
            if (n4 % this.menuSprite[0].getHeight() != 0) {
                ++n16;
            }
            if (n10 == 0) {
                ++n16;
            }
            if (n11 == 0) {
                ++n16;
            }
            int n17 = n;
            if (n13 != 0) {
                n17 += this.menuSprite[0].getWidth();
            }
            int n18 = n2 + n4 - this.menuSprite[0].getHeight();
            for (n14 = 0; n14 < n15; ++n14) {
                if (n10 != 0) {
                    graphics.drawImage(this.menuSprite[1], n17, n2, 0);
                }
                if (n11 != 0) {
                    graphics.drawImage(this.menuSprite[6], n17, n18, 0);
                }
                n17 += this.menuSprite[0].getWidth();
            }
            n14 = n2;
            if (n10 != 0) {
                n14 += this.menuSprite[0].getHeight();
            }
            int n19 = n + n3 - this.menuSprite[0].getWidth();
            for (int i = 0; i < n16; ++i) {
                if (n13 != 0) {
                    graphics.drawImage(this.menuSprite[3], n, n14, 0);
                }
                if (n12 != 0) {
                    graphics.drawImage(this.menuSprite[4], n19, n14, 0);
                }
                n14 += this.menuSprite[0].getHeight();
            }
            if (n13 != 0 && n10 != 0) {
                graphics.drawImage(this.menuSprite[0], n, n2, 0);
            }
            if (n12 != 0 && n10 != 0) {
                graphics.drawImage(this.menuSprite[2], n19, n2, 0);
            }
            if (n13 != 0 && n11 != 0) {
                graphics.drawImage(this.menuSprite[5], n, n18, 0);
            }
            if (n12 != 0 && n11 != 0) {
                graphics.drawImage(this.menuSprite[7], n19, n18, 0);
            }
        }
    }

    public void showNotify() {
        this.angleRotateOffset = 0;
        this.fadeCtr = 4;
        this.doRepaint = true;
        if (this.titlePanel != null) {
            this.titlePanel.doRepaint = true;
        }
        if (this.type == 15) {
            for (int i = 0; i < this.containedMenus.size(); ++i) {
                MenuCtl menuCtl = (MenuCtl)this.containedMenus.elementAt(i);
                menuCtl.showNotify();
            }
        }
    }

    public void setMenuAction(byte by, boolean bl) {
        this.actionEnabled[by] = bl;
    }
}

