/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class AniData {
    int numOfTexture;
    String[] textureName;
    int numOfClips;
    int[][] clip;
    int numOfFrames;
    int[] frameInfoList;
    int[][][] frames;
    int numOfAni;
    int[] aniInfo;
    int[][] ani;

    public void readFile(String FileName) {
        this.readFile(new DataInputStream(this.getClass().getResourceAsStream(FileName)));
    }

    public void readFile(DataInputStream in) {
        try {
            int a;
            byte b;
            byte[] fileHead = new byte[3];
            in.read(fileHead);
            this.numOfTexture = in.readShort();
            this.textureName = new String[this.numOfTexture];
            int i = 0;
            while (i < this.numOfTexture) {
                b = in.readByte();
                byte[] bb = new byte[b];
                in.read(bb);
                this.textureName[i] = new String(bb);
                ++i;
            }
            this.numOfClips = in.readShort();
            this.clip = new int[this.numOfClips][5];
            i = 0;
            while (i < this.numOfClips) {
                b = in.readByte();
                this.clip[i][0] = b & 0xFF;
                b = in.readByte();
                this.clip[i][1] = b & 0xFF;
                b = in.readByte();
                this.clip[i][2] = b & 0xFF;
                b = in.readByte();
                this.clip[i][3] = b & 0xFF;
                b = in.readByte();
                this.clip[i][4] = b & 0xFF;
                ++i;
            }
            this.numOfFrames = in.readShort();
            this.frameInfoList = new int[this.numOfFrames];
            this.frames = new int[this.numOfFrames][][];
            i = 0;
            while (i < this.numOfFrames) {
                this.frameInfoList[i] = in.readShort();
                this.frames[i] = new int[this.frameInfoList[i]][3];
                a = 0;
                while (a < this.frameInfoList[i]) {
                    this.frames[i][a][0] = in.readShort();
                    this.frames[i][a][1] = in.readShort();
                    this.frames[i][a][2] = in.readShort();
                    ++a;
                }
                ++i;
            }
            this.numOfAni = in.readShort();
            this.aniInfo = new int[this.numOfAni];
            this.ani = new int[this.numOfAni][];
            i = 0;
            while (i < this.numOfAni) {
                this.aniInfo[i] = in.readByte() & 0xFF;
                this.ani[i] = new int[this.aniInfo[i]];
                a = 0;
                while (a < this.aniInfo[i]) {
                    this.ani[i][a] = in.readByte() & 0xFF;
                    ++a;
                }
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

