/*
 * Decompiled with CFR 0.152.
 */
package unity;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import unity.Bundlet;

public class BundleMIDlet
extends MIDlet
implements Runnable,
CommandListener {
    private static final String OK_CMD = "Ok";
    private static final String EXIT_CMD = "Exit";
    private static final String BACK_CMD = "Back";
    private static final String BUNDLET_NAMES = "BUNDLET-NAMES";
    private static final String MORE_GAMES_MENU_ITEM = "More Games";
    private static final String ABOUT_MENU_ITEM = "About Item";
    private static final String ABOUT_TITLE = "About Title";
    private static final String ABOUT_TEXT = "ABOUT BundleMIDlet";
    private static final String MORE_GAMES_MENU_ICON = "/unity/mgicon.png";
    private static final String ABOUT_MENU_ITEM_ICON = "/unity/about.png";
    private static final String MORE_GAMES_PROPERTY = "UNITYBUNDLECATALOGURL";
    private static final String MIDLET_NAMES = "Test1, Test2";
    private static final String MIDLET_CLASSES = "unity.Bundlet.TestMidlet1, unity.Bundlet.TestMidlet2";
    private static final String MIDLET_ICONS = "/icon1.png, /icon2.png";
    public static final int EXIT_DEVICE_SPECIFIC = 1;
    public static final int EXIT_ALWAYS = 0;
    public static final int EXIT_NEVER = 2;
    private List midletSuiteMenu;
    String activeMidletClass;
    String activeMidletName;
    Hashtable activeMidletParams;
    Bundlet activeMidlet;
    boolean activeMidletDestroyOnExit;

    public String getBundletNames() {
        return "Turbo Pizza, Bubble Town";
    }

    public String getBundletClassNames() {
        return "com.iplay.turbopizza.TurboPizza, ObrBT";
    }

    public String getBundletIcons() {
        return "/i.png, /icon.png";
    }

    public String getBundletParams() {
        return "";
    }

    public int getExitOnShellOut() {
        return 2;
    }

    public boolean[] getDestroyOnExit() {
        return new boolean[]{true};
    }

    public boolean showAboutBox() {
        return false;
    }

    public void startApp() throws MIDletStateChangeException {
        if (this.activeMidlet != null) {
            this.activeMidlet.startBundlet();
        } else {
            this.displaySuiteMenu();
        }
    }

    public void pauseApp() {
        if (this.activeMidlet != null) {
            this.activeMidlet.pauseBundlet();
        }
    }

    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (this.activeMidlet != null) {
            this.activeMidlet.destroyBundlet(unconditional);
        }
    }

    private String[] getMidletNames() {
        String midletNames = this.getAppProperty(BUNDLET_NAMES);
        if (midletNames == null) {
            midletNames = this.getBundletNames();
        }
        Vector list = this.split(midletNames + "," + this.getMoreGamesItem(true), ',');
        String[] result = new String[list.size()];
        Enumeration i2 = list.elements();
        int j2 = 0;
        while (i2.hasMoreElements()) {
            result[j2++] = (String)i2.nextElement();
        }
        return result;
    }

    private Image[] getMidletIcons() {
        String iconNames = this.getBundletIcons();
        if (iconNames.length() == 0) {
            return null;
        }
        Vector icons = this.split(iconNames + "," + this.getMoreGamesItem(false), ',');
        Image[] result = new Image[icons.size()];
        Enumeration i2 = icons.elements();
        int j2 = 0;
        while (i2.hasMoreElements()) {
            try {
                result[j2] = Image.createImage((String)((String)i2.nextElement()));
            }
            catch (IOException e2) {
                result[j2] = null;
            }
            ++j2;
        }
        return result;
    }

    private String getMidletClass(int n2) {
        Vector midletClasses = this.split(this.getBundletClassNames() + "," + this.getMoreGamesItem(false), ',');
        return (String)midletClasses.elementAt(n2);
    }

    private Hashtable getMidletParams(int n2) {
        Vector params;
        Vector midletParams = this.split(this.getBundletParams(), '|');
        if (midletParams.size() > n2 && (params = this.split((String)midletParams.elementAt(n2), ':')).size() > 0) {
            Hashtable<String, String> result = new Hashtable<String, String>(params.size());
            Enumeration i2 = params.elements();
            while (i2.hasMoreElements()) {
                String keyValue = (String)i2.nextElement();
                int split = keyValue.indexOf(61);
                if (split <= -1) continue;
                result.put(keyValue.substring(0, split), keyValue.substring(split + 1));
            }
            return result;
        }
        return null;
    }

    private String getMidletName(int n2) {
        String[] names = this.getMidletNames();
        return names[n2];
    }

    private boolean getDestroyOnExit(int n2) {
        boolean result = true;
        boolean[] exitList = this.getDestroyOnExit();
        if (exitList.length > n2) {
            result = exitList[n2];
        }
        return result;
    }

    private String getMoreGamesItem(boolean title) {
        String moreGames = this.getAppProperty(MORE_GAMES_PROPERTY);
        if (moreGames != null && moreGames.length() > 0) {
            if (title) {
                return MORE_GAMES_MENU_ITEM;
            }
            return MORE_GAMES_MENU_ICON;
        }
        return "";
    }

    private Vector split(String list, char splitChar) {
        Vector<String> result = new Vector<String>();
        int start = 0;
        int splitPos = list.indexOf(splitChar);
        while (splitPos != -1) {
            String item = list.substring(start, splitPos).trim();
            result.addElement(item);
            start = splitPos + 1;
            splitPos = list.indexOf(splitChar, start);
        }
        String lastItem = list.substring(start).trim();
        if (lastItem.length() > 0) {
            result.addElement(lastItem);
        }
        return result;
    }

    private void displaySuiteMenu() {
        if (this.midletSuiteMenu == null) {
            this.midletSuiteMenu = new List(this.getAppProperty("MIDlet-Name"), 3, this.getMidletNames(), this.getMidletIcons());
            if (this.showAboutBox()) {
                Image aboutIcon = null;
                try {
                    aboutIcon = Image.createImage((String)ABOUT_MENU_ITEM_ICON);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.midletSuiteMenu.append(ABOUT_MENU_ITEM, aboutIcon);
            }
            this.midletSuiteMenu.addCommand(new Command(OK_CMD, 4, 1));
            this.midletSuiteMenu.addCommand(new Command(EXIT_CMD, 2, 2));
            this.midletSuiteMenu.setCommandListener((CommandListener)this);
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.midletSuiteMenu);
    }

    public void commandAction(Command c2, Displayable s) {
        if (c2.getCommandType() == 2) {
            this.notifyDestroyed();
        } else if (s != this.midletSuiteMenu) {
            this.displaySuiteMenu();
        } else {
            int menuIndex = this.midletSuiteMenu.getSelectedIndex();
            if (this.midletSuiteMenu.getString(menuIndex).equals(ABOUT_MENU_ITEM)) {
                Form about = new Form(ABOUT_TITLE);
                about.append(ABOUT_TEXT);
                about.addCommand(new Command(BACK_CMD, 4, 1));
                about.addCommand(new Command(EXIT_CMD, 2, 2));
                about.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)about);
            } else {
                this.midletSuiteMenu.setCommandListener(null);
                this.activeMidletClass = this.getMidletClass(menuIndex);
                this.activeMidletName = this.getMidletName(menuIndex);
                this.activeMidletParams = this.getMidletParams(menuIndex);
                this.activeMidletDestroyOnExit = this.getDestroyOnExit(menuIndex);
                Thread t = new Thread(this);
                t.start();
            }
        }
    }

    public void run() {
        if (this.activeMidletClass.equals(MORE_GAMES_MENU_ICON)) {
            try {
                if (!this.doShellOutExitNever()) {
                    this.midletSuiteMenu.setCommandListener((CommandListener)this);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.notifyDestroyed();
        } else {
            this.runMidlet(this.activeMidletClass);
        }
    }

    private void runMidlet(String midletClass) {
        try {
            this.midletSuiteMenu = null;
            System.gc();
            Class<?> cls = Class.forName(midletClass);
            Bundlet.setMidlet(this, this.activeMidletName, this.activeMidletParams, this.getExitOnShellOut(), this.activeMidletDestroyOnExit);
            this.activeMidlet = (Bundlet)cls.newInstance();
            this.activeMidlet.startBundlet();
        }
        catch (Exception e2) {
            this.activeMidlet = null;
            this.activeMidletClass = null;
            this.displaySuiteMenu();
        }
    }

    public void pausApp() {
        if (this.activeMidlet != null) {
            this.activeMidlet.pauseBundlet();
        }
    }

    public void exitMidlet() {
        this.activeMidlet = null;
        this.activeMidletClass = null;
        System.gc();
        this.displaySuiteMenu();
    }

    private boolean doShellOut() throws Exception {
        String url = this.getAppProperty(MORE_GAMES_PROPERTY);
        url = url.trim();
        this.platformRequest(url);
        return true;
    }

    private boolean doShellOutExitOnDevice() throws Exception {
        String url = this.getAppProperty(MORE_GAMES_PROPERTY);
        url = url.trim();
        boolean result = this.platformRequest(url);
        return result;
    }

    private boolean doShellOutExitNever() throws Exception {
        String url = this.getAppProperty(MORE_GAMES_PROPERTY);
        url = url.trim();
        this.platformRequest(url);
        return false;
    }

    private boolean doSprintShellOut() throws Exception {
        String url = this.getAppProperty(MORE_GAMES_PROPERTY);
        url = url.trim();
        com.sprintpcs.util.System.setExitURI((String)url);
        return true;
    }
}

