/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

abstract class GameCore
extends Canvas
implements Runnable {
    static Thread thread;
    static String debugstr;
    static int iLoadProgress;
    static Random random;
    public static GameCore canvas;
    private static boolean bHolding;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static int SCREEN_X_CENTER;
    static int SCREEN_Y_CENTER;
    static int MENU_WIDTH;
    static int MENU_HEIGHT;
    static int MENU_TOP;
    static int MENU_BASE;
    static int MENU_LEFT;
    static int MENU_RIGHT;
    static Graphics bbGraphics;
    static int COL_BACKGROUND;
    static final int FLAG_FONT2 = 1;
    static final int FLAG_FONT3 = 2;
    static final int FLAG_FONT4 = 4;
    static final int FLAG_BOLD = 8;
    static final int FLAG_NOSAVE = 16;
    static final int FLAG_NODRAW = 32;
    static final int FLAG_WRAP = 64;
    private static int selectedFont;
    public static Image[] fonts;
    private static int font1;
    private static int font2;
    private static int font3;
    private static int font4;
    private static Image monofont;
    static Image bar1;
    static Image bar2;
    static int softKeyflags;
    private static final int TAB_SIZE = 20;
    private static final int GAP = 1;
    private static final int SPACE = 4;
    static int LINE_HEIGHT;
    private static final int CHAR_AREA_WIDTH = 16;
    private static final int CHAR_AREA_HEIGHT = 16;
    static int[] charWidths;
    private static final int tab1 = 28;
    private static final int[] tabStops;
    private static int iHelpPage;
    static final String[] help;
    static String strIntro;
    static int SOFTKEY_HEIGHT;
    private static final int KEY_SOFTKEY_LEFT = -6;
    private static final int KEY_SOFTKEY_RIGHT = -7;
    static final String[] softs;
    private static int CMD_LEFT;
    private static int CMD_RIGHT;
    static final int CMD_NONE = 0;
    static final int GAME_STATE_NONE = 0;
    static final int GAME_STATE_LOAD = 1;
    static final int GAME_STATE_GAME_ON = 2;
    static final int GAME_STATE_PAUSED = 4;
    static final int GAME_STATE_MENU = 8;
    static final int GAME_STATE_LANGUAGE = 16;
    private static int GAME_STATE;
    private static int lastGAME_STATE;
    private static final int DEFINED_FRAME_RATE = 15;
    static final int FRAME_SPEED = 66;
    private static long timeFrameEnd;
    static String[] saSounds;
    public Player oSound;
    public VolumeControl oVolumeControl;
    public int iCurrentSound;
    static final int PAL_START = 145;
    static int loadType;
    static boolean bFirstRun;
    static int totalSteps;
    static int loadSteps;
    private static int font;
    private static int pos;
    private static int i;
    private static int j;
    private static int line;
    private static int wordsize;
    private static int cha;
    private static int textBase;
    private static int measure;
    static byte[] gameVars;
    static String[][] saList;
    static int MENU_SPLASH;
    static int iCurrentMenu;
    static int iCurrentButton;
    private static int iButtonCount;
    static int iCurrentButton_Type;
    private static int iCurrentButton_ValA;
    private static int iCurrentButton_ValB;
    static int preExitState;
    static final int TOGGLE = 0x1000000;
    static final int LIST = 0x2000000;
    static final int BUTTON = 0x3000000;
    static final int SPINNER = 0x4000000;
    private static int[] menuStack;
    static String[] saMenu;
    static int[] iaMenu;
    private static int[] iaRenderTypes;
    private static int totalVars;
    private static int menuStackPos;
    private static final int SCROLL_WIDTH = 80;
    private static final int BUTTONSX = 15;
    private static final int BUTTONSY = 110;
    private static final int BUTTON_STEP = 6;
    private static final int BUTTON_DATA = 26;
    private static final int BUTTON_GAP = 4;
    static final int K_0 = 0;
    static final int K_1 = 1;
    static final int K_2 = 2;
    static final int K_3 = 3;
    static final int K_4 = 4;
    static final int K_5 = 5;
    static final int K_6 = 6;
    static final int K_7 = 7;
    static final int K_8 = 8;
    static final int K_9 = 9;
    static final int K_STAR = 10;
    static final int K_HASH = 11;
    static final int K_UP = 12;
    static final int K_DOWN = 13;
    static final int K_LEFT = 14;
    static final int K_RIGHT = 15;
    static final int K_FIRE = 16;
    static final int K_ANY = 17;
    static int keysHeld;
    static int keysPressed;
    static boolean bHorizMenu;
    static String strGameTitle;
    private static RecordStore oRecordStore;
    private static boolean bRecordOpen;
    private static int[] sinetable;
    public static int sinval;
    public static int cosval;
    static final int SQRT_SIZE = 15;
    static final int LOAD_START = 1;
    static final int LOAD_MENU = 2;
    static final int LOAD_GAME = 3;
    static final int LOAD_MENU_IMAGES = 5;

    public void loadMIDI(int file, boolean loop) {
        try {
            this.offMIDI();
            this.oSound = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(saSounds[file]), (String)"audio/midi");
            this.oSound.realize();
            this.oVolumeControl = (VolumeControl)this.oSound.getControl("VolumeControl");
            this.oSound.prefetch();
            this.oVolumeControl.setLevel(this.oVolumeControl.getLevel());
            if (loop) {
                this.oSound.setLoopCount(-1);
            } else {
                this.oSound.setLoopCount(1);
            }
            this.oSound.start();
            this.iCurrentSound = file;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void offMIDI() {
        if (this.oSound != null) {
            if (this.oSound.getState() == 400) {
                try {
                    this.oSound.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.oSound.deallocate();
            this.oSound.close();
            this.oSound = null;
            System.gc();
        }
    }

    public void vibrate(int time) {
        try {
            Display.getDisplay((MIDlet)GameMIDlet.midlet).vibrate(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GameCore() {
        canvas = this;
        thread = new Thread(this);
    }

    static void nuke() {
    }

    static void prime() {
        canvas.setFullScreenMode(true);
        random = new Random();
        fonts = new Image[12];
        GameCore.fonts[0] = GameCore.loadImage("/font2A.png");
        GameCore.fonts[1] = GameCore.loadImage("/font2B.png");
        GameCore.fonts[2] = GameCore.loadImage("/font2C.png");
        GameCore.fonts[3] = GameCore.loadImage("/font1A.png");
        GameCore.fonts[4] = GameCore.loadImage("/font1B.png");
        GameCore.fonts[5] = GameCore.loadImage("/font1C.png");
        GameCore.fonts[9] = GameCore.loadImage("/font4A.png");
        GameCore.fonts[10] = GameCore.loadImage("/font4B.png");
        GameCore.fonts[11] = GameCore.loadImage("/font4C.png");
        bar1 = GameCore.loadImage("/SoftKeyMenu.png");
        bar2 = GameCore.loadImage("/SoftKeyIngame.png");
        SCREEN_WIDTH = canvas.getWidth();
        SCREEN_HEIGHT = canvas.getHeight();
        MENU_WIDTH = SCREEN_WIDTH < 160 ? 128 : (SCREEN_WIDTH < 190 ? 176 : (SCREEN_WIDTH < 210 ? 208 : (SCREEN_WIDTH < 300 ? 240 : 352)));
        MENU_LEFT = (SCREEN_WIDTH - MENU_WIDTH) / 2;
        MENU_RIGHT = MENU_LEFT + MENU_WIDTH;
        SCREEN_X_CENTER = MENU_LEFT + MENU_WIDTH / 2;
        MENU_TOP = 0;
        SCREEN_HEIGHT = SCREEN_HEIGHT < 130 ? 128 : (SCREEN_HEIGHT < 170 ? 160 : (SCREEN_HEIGHT < 225 ? (SCREEN_WIDTH == 208 ? 208 : 220) : (SCREEN_HEIGHT < 302 ? 300 : (SCREEN_HEIGHT < 390 ? 320 : 416))));
        MENU_HEIGHT = SCREEN_HEIGHT;
        MENU_BASE = MENU_TOP + MENU_HEIGHT;
        SCREEN_Y_CENTER = MENU_TOP + MENU_HEIGHT / 2;
    }

    static Image buildString(String s, int w, int h, int col, Image bImg, int flags) {
        int x;
        Image img = Image.createImage((int)w, (int)h);
        Graphics g = img.getGraphics();
        g.setColor(col);
        g.fillRect(0, 0, w, h);
        if (bImg != null) {
            for (int y = 0; y < h; y += bImg.getHeight()) {
                for (x = 0; x < w; x += bImg.getWidth()) {
                    g.drawImage(bImg, x, y, 0);
                }
            }
        }
        int cha = 32;
        x = 0;
        int y = 0;
        int tab = 0;
        g.setClip(x, y, w, 16);
        for (int i = 0; i < s.length(); ++i) {
            int wordStart;
            cha = s.charAt(i);
            int wordEnd = wordStart = i;
            int wordWidth = 0;
            while (cha > 32 && cha <= 125) {
                wordWidth += charWidths[cha - 32] + 1;
                ++wordEnd;
                if (++i >= s.length()) break;
                cha = s.charAt(i);
            }
            if ((flags & 0x40) > 0 && x + wordWidth > w) {
                x = 0;
                tab = 0;
                g.setClip(x, y += LINE_HEIGHT, w, 16);
            }
            for (int wordCha = wordStart; wordCha < wordEnd; ++wordCha) {
                cha = s.charAt(wordCha);
                if (cha == 9) {
                    x = tabStops[tab];
                    ++tab;
                    continue;
                }
                if (cha == 10 || cha < 32 || cha > 125) continue;
                cha = (char)(cha - 32);
                g.drawImage(fonts[selectedFont + cha / 32], x, y + cha % 32 * -16, 0);
                if ((flags & 8) > 0) {
                    g.drawImage(fonts[selectedFont + cha / 32], ++x, y + cha % 32 * -16, 0);
                }
                x += charWidths[cha] + 1;
            }
            x += 4;
        }
        return img;
    }

    static Image loadImage(String path) {
        Image img;
        try {
            img = Image.createImage((String)path);
        }
        catch (Exception e) {
            System.out.println("WARNING: Could not load image '" + path + "'");
            return null;
        }
        return img;
    }

    static Image loadImage(String file, long size, byte[] pal) {
        Image img = null;
        byte[] head = new byte[]{0, 0, 0, 48, 80, 76, 84, 69};
        byte[] palette = new byte[56];
        System.arraycopy(head, 0, palette, 0, 8);
        System.arraycopy(pal, 0, palette, 8, 48);
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        try {
            int j;
            InputStream inputStream = file.getClass().getResourceAsStream(file);
            if (inputStream == null) {
                System.out.println("ERROR: Image file not found [" + file + "]");
                return null;
            }
            byte[] b = new byte[(int)size];
            for (j = 0; j < b.length; ++j) {
                b[j] = (byte)inputStream.read();
            }
            inputStream.read(b, 0, (int)size);
            for (j = 0; j < palette.length; ++j) {
                b[145 + j] = palette[j];
            }
            int c = -1;
            int len = palette.length - 4;
            int off = 149;
            long crc = 0L;
            while (--len >= 0) {
                c = crc_table[(c ^ b[off++]) & 0xFF] ^ c >>> 8;
            }
            crc = (long)(~c) & 0xFFFFFFFFL;
            b[145 + palette.length + 0] = (byte)(crc >>> 24 & 0xFFL);
            b[145 + palette.length + 1] = (byte)(crc >>> 16 & 0xFFL);
            b[145 + palette.length + 2] = (byte)(crc >>> 8 & 0xFFL);
            b[145 + palette.length + 3] = (byte)(crc & 0xFFL);
            try {
                img = Image.createImage((byte[])b, (int)0, (int)b.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            inputStream.close();
            inputStream = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    static void loadMenuData() {
        GameCore.OpenRecordStore();
        byte[] load = GameCore.LoadByteArray(1);
        if (load != null) {
            bFirstRun = false;
            gameVars = load;
        } else {
            bFirstRun = true;
            gameVars = new byte[totalVars];
        }
        GameCore.CloseRecordStore();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            block2: while (true) {
                if (GameCore.loadType > 0) {
                    this.load(GameCore.loadType);
                    GameCore.loadType = 0;
                    continue;
                }
                if (GameCore.inState(0)) {
                    GameCore.loadType = 1;
                    continue;
                }
                GameCore.timeFrameEnd = System.currentTimeMillis() + 66L;
                this.repaint();
                this.serviceRepaints();
                while (true) {
                    if (System.currentTimeMillis() < GameCore.timeFrameEnd) ** break;
                    continue block2;
                    GameCore.thread.yield();
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static void stepLoad() {
        thread.yield();
    }

    static boolean inState(int state) {
        return GAME_STATE == state;
    }

    static boolean lastState(int state) {
        return lastGAME_STATE == state;
    }

    static void setState(int state) {
        lastGAME_STATE = GAME_STATE;
        GAME_STATE = state;
    }

    static void drawImage(Image img, int ix, int iy, int ip) {
        if (img != null) {
            bbGraphics.drawImage(img, ix, iy, ip);
        }
    }

    public void paint(Graphics g) {
        if (bbGraphics == null) {
            bbGraphics = g;
            bbGraphics.setColor(COL_BACKGROUND);
            bbGraphics.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        }
        if (GameCore.inState(0)) {
            return;
        }
        if (GameCore.inState(1)) {
            this.renderLoadingScreen();
            this.renderMenu();
        } else if (GameCore.inState(8)) {
            this.renderMenu();
        } else if (GameCore.inState(2)) {
            this.render();
        } else if (GameCore.inState(16)) {
            this.renderMenu();
        } else if (GameCore.inState(4)) {
            this.renderMenu();
        }
        if (GameCore.inState(2)) {
            if (bar2 != null) {
                int i = MENU_WIDTH / 22 + 1;
                while (--i >= 0) {
                    bbGraphics.drawImage(bar2, MENU_LEFT + i * 22, MENU_BASE - SOFTKEY_HEIGHT - 1, 0);
                }
            }
            if (CMD_LEFT != 0) {
                GameCore.drawString(saMenu[CMD_LEFT], MENU_LEFT + 10, MENU_BASE - SOFTKEY_HEIGHT + 1, softKeyflags);
            }
            if (CMD_RIGHT != 0) {
                GameCore.drawString(saMenu[CMD_RIGHT], MENU_RIGHT - GameCore.getStringWidth(saMenu[CMD_RIGHT]) - 10, MENU_BASE - SOFTKEY_HEIGHT + 1, softKeyflags);
            }
        } else if (!GameCore.inState(1) && iCurrentMenu != MENU_SPLASH && bar1 != null) {
            int i = MENU_WIDTH / 22 + 1;
            while (--i >= 0) {
                bbGraphics.drawImage(bar1, MENU_LEFT + i * 22, MENU_BASE - SOFTKEY_HEIGHT - 1, 0);
            }
            if (CMD_LEFT != 0) {
                GameCore.drawString(saMenu[CMD_LEFT], MENU_LEFT + 10, MENU_BASE - SOFTKEY_HEIGHT + 1, softKeyflags);
            }
            if (CMD_RIGHT != 0) {
                GameCore.drawString(saMenu[CMD_RIGHT], MENU_RIGHT - GameCore.getStringWidth(saMenu[CMD_RIGHT]) - 10, MENU_BASE - SOFTKEY_HEIGHT + 1, softKeyflags);
            }
        }
        if (MENU_LEFT != 0) {
            g.setColor(0);
            g.fillRect(0, 0, MENU_LEFT, SCREEN_HEIGHT - 1);
            g.fillRect(MENU_RIGHT, 0, SCREEN_WIDTH - 1, SCREEN_HEIGHT - 1);
        }
        if (MENU_TOP != 0) {
            g.setColor(0);
            g.fillRect(0, 0, SCREEN_WIDTH - 1, MENU_TOP);
            g.fillRect(0, MENU_BASE, SCREEN_WIDTH - 1, SCREEN_HEIGHT - 1);
        }
    }

    static void drawMonoString(String str, int x, int y) {
        int size = monofont.getWidth();
        int pos = 0;
        bbGraphics.setClip(MENU_LEFT, y, MENU_WIDTH, size);
        for (int i = 0; i < str.length(); ++i) {
            int cha = str.charAt(i) - 65;
            GameCore.drawImage(monofont, x + pos, y - cha * size, 0);
            pos += size + 1;
        }
        bbGraphics.setClip(MENU_LEFT, MENU_TOP, MENU_WIDTH, MENU_HEIGHT);
    }

    static void drawString(String str, int x, int y, int flags) {
        if (str == null || bbGraphics == null) {
            return;
        }
        font = 0;
        if ((flags & 1) > 0) {
            font = 3;
        }
        if ((flags & 2) > 0) {
            font = 6;
        }
        if ((flags & 4) > 0) {
            font = 9;
        }
        pos = 0;
        int tab = 0;
        bbGraphics.setClip(MENU_LEFT, y -= 4, MENU_WIDTH, 16);
        for (i = 0; i < str.length(); ++i) {
            cha = str.charAt(i);
            if (cha == 9) {
                pos = tabStops[tab];
                ++tab;
                continue;
            }
            if (cha > 128) {
                switch (cha) {
                    case 193: {
                        cha = 97;
                        break;
                    }
                    case 192: {
                        cha = 98;
                        break;
                    }
                    case 196: {
                        cha = 99;
                        break;
                    }
                    case 199: {
                        cha = 100;
                        break;
                    }
                    case 201: {
                        cha = 101;
                        break;
                    }
                    case 200: {
                        cha = 102;
                        break;
                    }
                    case 202: {
                        cha = 103;
                        break;
                    }
                    case 205: {
                        cha = 104;
                        break;
                    }
                    case 206: {
                        cha = 105;
                        break;
                    }
                    case 211: {
                        cha = 106;
                        break;
                    }
                    case 212: {
                        cha = 107;
                        break;
                    }
                    case 214: {
                        cha = 108;
                        break;
                    }
                    case 220: {
                        cha = 109;
                        break;
                    }
                    case 209: {
                        cha = 110;
                        break;
                    }
                    case 223: {
                        cha = 111;
                        break;
                    }
                    case 352: {
                        cha = 116;
                        break;
                    }
                    case 221: {
                        cha = 119;
                        break;
                    }
                    case 381: {
                        cha = 120;
                        break;
                    }
                    default: {
                        cha = 32;
                    }
                }
            }
            GameCore.drawImage(fonts[font + (cha -= 32) / 32], x + pos, y + cha % 32 * -16, 0);
            if ((flags & 8) > 0) {
                pos += charWidths[cha] + 1 + 1;
                continue;
            }
            pos += charWidths[cha] + 1;
        }
        pos += x;
        bbGraphics.setClip(MENU_LEFT, MENU_TOP, MENU_WIDTH, MENU_HEIGHT);
    }

    public static boolean drawStringWrap(Graphics gra, String str, int x, int y, int width, int height, int startline, int flags) {
        font = 0;
        if ((flags & 1) > 0) {
            font = 3;
        }
        if ((flags & 2) > 0) {
            font = 6;
        }
        if ((flags & 4) > 0) {
            font = 9;
        }
        int starty = 0;
        i = 0;
        line = 0;
        pos = 0;
        if ((flags & 0x20) == 0) {
            gra.setClip(MENU_LEFT, y, MENU_WIDTH, 16);
        }
        while (i < str.length()) {
            wordsize = 0;
            for (j = i; j < str.length() && str.charAt(j) != ' '; ++j) {
                cha = str.charAt(j);
                if (cha > 128) {
                    switch (cha) {
                        case 193: {
                            cha = 97;
                            break;
                        }
                        case 192: {
                            cha = 98;
                            break;
                        }
                        case 196: {
                            cha = 99;
                            break;
                        }
                        case 199: {
                            cha = 100;
                            break;
                        }
                        case 201: {
                            cha = 101;
                            break;
                        }
                        case 200: {
                            cha = 102;
                            break;
                        }
                        case 202: {
                            cha = 103;
                            break;
                        }
                        case 205: {
                            cha = 104;
                            break;
                        }
                        case 206: {
                            cha = 105;
                            break;
                        }
                        case 211: {
                            cha = 106;
                            break;
                        }
                        case 212: {
                            cha = 107;
                            break;
                        }
                        case 214: {
                            cha = 108;
                            break;
                        }
                        case 220: {
                            cha = 109;
                            break;
                        }
                        case 209: {
                            cha = 110;
                            break;
                        }
                        case 223: {
                            cha = 111;
                            break;
                        }
                        case 352: {
                            cha = 116;
                            break;
                        }
                        case 221: {
                            cha = 119;
                            break;
                        }
                        case 381: {
                            cha = 120;
                            break;
                        }
                        default: {
                            cha = 32;
                        }
                    }
                }
                if ((cha -= 32) < 0 || cha >= charWidths.length) continue;
                wordsize += charWidths[cha] + 1;
            }
            if (pos + wordsize > width) {
                pos = 0;
                starty += LINE_HEIGHT;
                if ((line += LINE_HEIGHT) / LINE_HEIGHT == startline) {
                    starty = 0;
                }
                if (starty > height && line / LINE_HEIGHT >= startline) {
                    gra.setClip(MENU_LEFT, MENU_TOP, MENU_WIDTH, MENU_HEIGHT);
                    return false;
                }
                gra.setClip(MENU_LEFT, y + starty, MENU_WIDTH, 16);
            }
            while (i < str.length() && str.charAt(i) != ' ') {
                cha = str.charAt(i);
                if (cha > 128) {
                    switch (cha) {
                        case 193: {
                            cha = 97;
                            break;
                        }
                        case 192: {
                            cha = 98;
                            break;
                        }
                        case 196: {
                            cha = 99;
                            break;
                        }
                        case 199: {
                            cha = 100;
                            break;
                        }
                        case 201: {
                            cha = 101;
                            break;
                        }
                        case 200: {
                            cha = 102;
                            break;
                        }
                        case 202: {
                            cha = 103;
                            break;
                        }
                        case 205: {
                            cha = 104;
                            break;
                        }
                        case 206: {
                            cha = 105;
                            break;
                        }
                        case 211: {
                            cha = 106;
                            break;
                        }
                        case 212: {
                            cha = 107;
                            break;
                        }
                        case 214: {
                            cha = 108;
                            break;
                        }
                        case 220: {
                            cha = 109;
                            break;
                        }
                        case 209: {
                            cha = 110;
                            break;
                        }
                        case 223: {
                            cha = 111;
                            break;
                        }
                        case 352: {
                            cha = 116;
                            break;
                        }
                        case 221: {
                            cha = 119;
                            break;
                        }
                        case 381: {
                            cha = 120;
                            break;
                        }
                        default: {
                            cha = 32;
                        }
                    }
                }
                if ((cha -= 32) > 0 && cha < charWidths.length) {
                    if (line / LINE_HEIGHT >= startline) {
                        gra.drawImage(fonts[font + cha / 32], x + pos, y + starty + cha % 32 * -16, 0);
                    }
                    pos += charWidths[cha] + 1;
                }
                ++i;
            }
            pos += 4;
            ++i;
        }
        if ((flags & 0x10) == 0) {
            textBase = y + line + LINE_HEIGHT;
        }
        gra.setClip(MENU_LEFT, MENU_TOP, MENU_WIDTH, MENU_HEIGHT);
        return true;
    }

    static void drawStringInt(String str, int value, int x, int y) {
        GameCore.drawString(str + value, x, y, 8);
    }

    static int getStringWidth(String str) {
        if (str == null) {
            return 0;
        }
        int len = 0;
        for (i = 0; i < str.length(); ++i) {
            cha = str.charAt(i);
            if (cha == 32) {
                len += 4;
                continue;
            }
            if (cha == 9) {
                len += 20;
                len /= 20;
                len *= 20;
                continue;
            }
            if (cha > 128) {
                switch (cha) {
                    case 193: {
                        cha = 97;
                        break;
                    }
                    case 192: {
                        cha = 98;
                        break;
                    }
                    case 196: {
                        cha = 99;
                        break;
                    }
                    case 199: {
                        cha = 100;
                        break;
                    }
                    case 201: {
                        cha = 101;
                        break;
                    }
                    case 200: {
                        cha = 102;
                        break;
                    }
                    case 202: {
                        cha = 103;
                        break;
                    }
                    case 205: {
                        cha = 104;
                        break;
                    }
                    case 206: {
                        cha = 105;
                        break;
                    }
                    case 211: {
                        cha = 106;
                        break;
                    }
                    case 212: {
                        cha = 107;
                        break;
                    }
                    case 214: {
                        cha = 108;
                        break;
                    }
                    case 220: {
                        cha = 109;
                        break;
                    }
                    case 209: {
                        cha = 110;
                        break;
                    }
                    case 223: {
                        cha = 111;
                        break;
                    }
                    case 352: {
                        cha = 116;
                        break;
                    }
                    case 221: {
                        cha = 119;
                        break;
                    }
                    case 381: {
                        cha = 120;
                        break;
                    }
                    default: {
                        cha = 32;
                    }
                }
            }
            len += charWidths[cha -= 32] + 1;
        }
        return len;
    }

    private static int getMenuString(String s) {
        int i;
        for (i = 0; i < saMenu.length; ++i) {
            if (!s.equals(saMenu[i])) continue;
            return i;
        }
        i = saMenu.length;
        String[] new_saMenu = new String[i + 1];
        System.arraycopy(saMenu, 0, new_saMenu, 0, i);
        new_saMenu[i] = s;
        saMenu = new_saMenu;
        return i;
    }

    static int addMenu(String title, int softLeft, int softRight, String[] buttons, int[] types, Image[] images, int state) {
        menuStack = new int[menuStack.length + 1];
        int buttonCount = 0;
        if (buttons != null) {
            buttonCount = buttons.length;
        }
        int[] new_iaMenu = new int[buttonCount + 2];
        new_iaMenu[0] = (state << 24) + buttonCount;
        if (title != null) {
            new_iaMenu[0] = new_iaMenu[0] + (GameCore.getMenuString(title) << 16);
        }
        new_iaMenu[1] = softLeft << 24;
        new_iaMenu[1] = new_iaMenu[1] + (softRight << 8);
        for (int i = 0; i < buttonCount; ++i) {
            new_iaMenu[i + 2] = types[i] + (GameCore.getMenuString(buttons[i]) << 16);
        }
        int oldlength = iaMenu.length;
        int[] temp_iaMenu = new int[new_iaMenu.length + oldlength];
        System.arraycopy(iaMenu, 0, temp_iaMenu, 0, oldlength);
        System.arraycopy(new_iaMenu, 0, temp_iaMenu, oldlength, new_iaMenu.length);
        iaMenu = temp_iaMenu;
        iaRenderTypes = new int[iaMenu.length];
        return oldlength;
    }

    static int addSoft(String soft) {
        return GameCore.getMenuString(soft);
    }

    static void addMenuLink(int menu, int button, int target) {
        if (button < 2) {
            int n = menu + 1;
            iaMenu[n] = iaMenu[n] + (target << (button == 0 ? 16 : 0));
        } else {
            int n = menu + 1 + (button - 1);
            iaMenu[n] = iaMenu[n] + target;
        }
    }

    static int addMenuVar(int menu, int button) {
        int n = menu + 2 + button;
        iaMenu[n] = iaMenu[n] + totalVars;
        return GameCore.addVar();
    }

    static int addVar() {
        return ++totalVars - 1;
    }

    static int addList(String[] list, int menu, int button) {
        String[][] newList = new String[saList.length + 1][0];
        System.arraycopy(saList, 0, newList, 0, saList.length);
        newList[GameCore.saList.length] = list;
        int n = menu + 2 + button;
        iaMenu[n] = iaMenu[n] + (saList.length << 8);
        int n2 = menu + 2 + button;
        iaMenu[n2] = iaMenu[n2] + GameCore.addVar();
        saList = newList;
        return iaMenu[menu + 2 + button] & 0xFF;
    }

    static void pushMenu(int menu) {
        boolean bFound = false;
        for (int i = 0; i < menuStackPos; ++i) {
            if (menuStack[i] != menu) continue;
            menuStackPos = i;
            bFound = true;
            break;
        }
        if (!bFound) {
            GameCore.menuStack[++GameCore.menuStackPos] = menu;
        }
        GameCore.getMenuData();
    }

    static void popMenu() {
        if (menuStackPos > 0) {
            --menuStackPos;
        }
        GameCore.getMenuData();
    }

    private static void getMenuData() {
        iCurrentMenu = menuStack[menuStackPos];
        iCurrentButton = iaMenu[iCurrentMenu] >> 8 & 0xFF;
        iButtonCount = iaMenu[iCurrentMenu] & 0xFF;
        CMD_LEFT = iaMenu[iCurrentMenu + 1] >> 24 & 0xFF;
        CMD_RIGHT = iaMenu[iCurrentMenu + 1] >> 8 & 0xFF;
        int newState = iaMenu[iCurrentMenu] >> 24 & 0xFF;
        lastGAME_STATE = GAME_STATE;
        GAME_STATE = newState;
        GameCore.shiftMenu(0);
    }

    private static void shiftMenu(int dir) {
        if (iButtonCount > 0) {
            if ((iCurrentButton += dir) < 0) {
                iCurrentButton = iButtonCount - 1;
            }
            if (iCurrentButton >= iButtonCount) {
                iCurrentButton = 0;
            }
            GameCore.iaMenu[GameCore.iCurrentMenu] = (iaMenu[iCurrentMenu] & 0xFFFF00FF) + (iCurrentButton << 8);
            iCurrentButton_Type = iaMenu[iCurrentMenu + 2 + iCurrentButton] & 0xFF000000;
            iCurrentButton_ValA = iaMenu[iCurrentMenu + 2 + iCurrentButton] >> 8 & 0xFF;
            iCurrentButton_ValB = iaMenu[iCurrentMenu + 2 + iCurrentButton] & 0xFF;
        }
        canvas.userShift(dir);
    }

    static void drawMenuItems() {
        int str = 0;
        for (int i = 0; i < iButtonCount; ++i) {
            str = iaMenu[iCurrentMenu + i + 2] >> 16 & 0xFF;
            int type = iaMenu[iCurrentMenu + i + 2] & 0xFF000000;
            int valA = iaMenu[iCurrentMenu + i + 2] >> 8 & 0xFF;
            int valB = iaMenu[iCurrentMenu + i + 2] & 0xFF;
            int renderType = iaRenderTypes[iCurrentMenu + i + 2];
            canvas.drawMenuItem(i, saMenu[str], type, valA, valB, renderType, iButtonCount);
        }
    }

    static void basicMenu(int i, String str, int type, int valA, int valB) {
        int x = MENU_LEFT + 15;
        int y = MENU_TOP + 110 + i * (LINE_HEIGHT + 4);
        int w = MENU_WIDTH - 30;
        int h = LINE_HEIGHT;
        bbGraphics.setColor(8290170);
        bbGraphics.drawRect(x + 1, y + 1, w + 3, h);
        bbGraphics.setColor(14575360);
        bbGraphics.fillRect(x + w + 1, y, 3, h + 1);
        if (i == iCurrentButton) {
            bbGraphics.setColor(5851538);
            bbGraphics.fillRect(x, y, w, h);
            bbGraphics.setColor(3614845);
            bbGraphics.drawRect(x, y, w, h);
        } else {
            bbGraphics.setColor(0xFFFFFF);
            bbGraphics.fillRect(x, y, w, h);
            bbGraphics.setColor(14407376);
            bbGraphics.drawRect(x, y, w, h);
        }
        --y;
        int flags = i == iCurrentButton ? 0 : 0;
        switch (type) {
            case 0x3000000: {
                break;
            }
            case 0x1000000: {
                GameCore.drawString(str, x + 6 + 2, y, flags + 8);
                GameCore.drawString(gameVars[valB] == 1 ? "ON" : "OFF", x + w - 26 + 1, y, flags);
                break;
            }
            case 0x2000000: {
                GameCore.drawString(str, x + 6 + 2, y, flags);
                y += LINE_HEIGHT;
                break;
            }
            case 0x4000000: {
                GameCore.drawString(str, x + 6 + 2, y, flags + 8);
                GameCore.drawString("<" + gameVars[valB] + ">", x + w - 26 - 5, y, flags);
            }
        }
    }

    public static void menuSelect(int dir) {
        if (iButtonCount > 0) {
            if (iCurrentButton_Type == 0x3000000 && dir == 0) {
                if (!canvas.postSelect(dir) && iCurrentButton_ValB > 0) {
                    GameCore.pushMenu(iCurrentButton_ValB);
                }
            } else if (iCurrentButton_Type == 0x2000000) {
                if (dir == 0) {
                    dir = 1;
                }
                int n = iCurrentButton_ValB;
                gameVars[n] = (byte)(gameVars[n] + dir);
                if (gameVars[iCurrentButton_ValB] >= saList[iCurrentButton_ValA].length) {
                    GameCore.gameVars[GameCore.iCurrentButton_ValB] = 0;
                }
                if (gameVars[iCurrentButton_ValB] < 0) {
                    GameCore.gameVars[GameCore.iCurrentButton_ValB] = (byte)(saList[iCurrentButton_ValA].length - 1);
                }
                canvas.postSelect(dir);
            } else if (iCurrentButton_Type == 0x1000000) {
                if (dir == 0) {
                    dir = 1;
                }
                GameCore.gameVars[GameCore.iCurrentButton_ValB] = (byte)(gameVars[iCurrentButton_ValB] != 1 ? 1 : 0);
                canvas.postSelect(dir);
            } else if (iCurrentButton_Type == 0x4000000) {
                if (dir == 0) {
                    dir = 1;
                }
                int n = iCurrentButton_ValB;
                gameVars[n] = (byte)(gameVars[n] + dir);
                canvas.postSelect(dir);
            }
        } else if (dir == 0) {
            canvas.postSelect(dir);
        }
    }

    static boolean processSofts(int key) {
        if (key == -6) {
            key = CMD_LEFT;
            if ((iaMenu[iCurrentMenu + 1] >> 16 & 0xFF) > 0) {
                GameCore.pushMenu(iaMenu[iCurrentMenu + 1] >> 16 & 0xFF);
                return true;
            }
            if (CMD_LEFT != 0) {
                return canvas.userSoft(key);
            }
        } else if (key == -7) {
            key = CMD_RIGHT;
            if ((iaMenu[iCurrentMenu + 1] & 0xFF) > 0) {
                GameCore.pushMenu(iaMenu[iCurrentMenu + 1] & 0xFF);
                return true;
            }
            if (CMD_RIGHT != 0) {
                return canvas.userSoft(key);
            }
        }
        return false;
    }

    static boolean isHeld(int key) {
        return (keysHeld >> key & 1) == 1;
    }

    static boolean wasPressed(int key) {
        boolean r;
        boolean bl = r = (keysPressed >> key & 1) == 1;
        if (r) {
            keysPressed -= 1 << key;
        }
        return r;
    }

    protected final void keyReleased(int key) {
        keysHeld ^= 0x20000;
        int gameKey = 0;
        try {
            gameKey = this.getGameAction(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (GameCore.inState(2)) {
            if (key >= 48 && key <= 57) {
                keysHeld -= 1 << key - 48;
            } else if (gameKey == 1) {
                keysHeld -= 4096;
            } else if (gameKey == 6) {
                keysHeld -= 8192;
            } else if (gameKey == 2) {
                keysHeld -= 16384;
            } else if (gameKey == 5) {
                keysHeld -= 32768;
            } else if (gameKey == 8) {
                keysHeld -= 65536;
            } else if (key == 42) {
                keysHeld -= 1024;
            } else if (key == 35) {
                keysHeld -= 2048;
            }
        }
    }

    protected final void keyPressed(int key) {
        keysHeld |= 0x20000;
        keysPressed |= 0x20000;
        if (GameCore.processSofts(key)) {
            return;
        }
        int gameKey = 0;
        try {
            gameKey = this.getGameAction(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (GameCore.inState(8) || GameCore.inState(4) || GameCore.inState(16)) {
            if (gameKey == 1 || key == 50) {
                GameCore.shiftMenu(-1);
            } else if (gameKey == 6 || key == 56) {
                GameCore.shiftMenu(1);
            } else if (gameKey == 2 || key == 52) {
                GameCore.menuSelect(-1);
            } else if (gameKey == 5 || key == 54) {
                GameCore.menuSelect(1);
            } else if (gameKey == 8 || key == 53) {
                GameCore.menuSelect(0);
            }
        } else if (GameCore.inState(2)) {
            if (key == -6) {
                key = CMD_LEFT;
                if ((iaMenu[iCurrentMenu + 1] >> 16 & 0xFF) > 0) {
                    GameCore.pushMenu(iaMenu[iCurrentMenu + 1] >> 16 & 0xFF);
                }
            } else if (key == -7) {
                key = CMD_RIGHT;
                if ((iaMenu[iCurrentMenu + 1] & 0xFF) > 0) {
                    GameCore.pushMenu(iaMenu[iCurrentMenu + 1] & 0xFF);
                }
            }
            if (key >= 48 && key <= 57) {
                keysHeld |= 1 << key - 48;
                keysPressed |= 1 << key - 48;
            } else if (gameKey == 1) {
                keysHeld |= 0x1000;
                keysPressed |= 0x1000;
            } else if (gameKey == 6) {
                keysHeld |= 0x2000;
                keysPressed |= 0x2000;
            } else if (gameKey == 2) {
                keysHeld |= 0x4000;
                keysPressed |= 0x4000;
            } else if (gameKey == 5) {
                keysHeld |= 0x8000;
                keysPressed |= 0x8000;
            } else if (gameKey == 8) {
                keysHeld |= 0x10000;
                keysPressed |= 0x10000;
            } else if (key == 42) {
                keysHeld |= 0x400;
                keysPressed |= 0x400;
            } else if (key == 35) {
                keysHeld |= 0x800;
                keysPressed |= 0x800;
            } else {
                keysHeld = 0;
                keysPressed = 0;
            }
        }
    }

    static String getStoreData() {
        String s = "";
        try {
            GameCore.OpenRecordStore();
            s = s + "Size Avail:" + oRecordStore.getSizeAvailable();
            GameCore.CloseRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    private static void OpenRecordStore() {
        try {
            oRecordStore = RecordStore.openRecordStore((String)strGameTitle, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void CloseRecordStore() {
        try {
            oRecordStore.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] LoadByteArray(int iRecordID) {
        try {
            try {
                return oRecordStore.getRecord(iRecordID);
            }
            catch (RecordStoreException rse) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void SaveByteArray(byte[] recordData, int iRecordID) {
        try {
            try {
                oRecordStore.setRecord(iRecordID, recordData, 0, recordData.length);
            }
            catch (RecordStoreException rse) {
                try {
                    oRecordStore.addRecord(recordData, 0, recordData.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        GameCore.OpenRecordStore();
        GameCore.SaveByteArray(gameVars, 1);
        GameCore.CloseRecordStore();
    }

    static void getSineCos(int angle) {
        if (angle < 0) {
            angle = 360 + angle;
            angle %= 360;
        }
        if (angle >= 360) {
            angle %= 360;
        }
        if (angle >= 270) {
            angle -= 360;
            angle = 0 - angle;
            sinval = 0 - sinetable[angle];
            angle -= 90;
            angle = 0 - angle;
            cosval = sinetable[angle];
            return;
        }
        if (angle >= 180) {
            sinval = 0 - sinetable[angle -= 180];
            angle -= 90;
            angle = 0 - angle;
            cosval = 0 - sinetable[angle];
            return;
        }
        if (angle >= 90) {
            angle -= 180;
            angle = 0 - angle;
            sinval = sinetable[angle];
            angle -= 90;
            angle = 0 - angle;
            cosval = 0 - sinetable[angle];
            return;
        }
        if (angle < 90) {
            sinval = sinetable[angle];
            angle -= 90;
            angle = 0 - angle;
            cosval = sinetable[angle];
            return;
        }
    }

    static long sqrtL(long val) {
        if (val <= 0L) {
            return 0L;
        }
        long guess = 0L;
        long bit = 32768L;
        do {
            if ((guess ^= bit) * guess <= val) continue;
            guess ^= bit;
        } while ((bit >>= 1) != 0L);
        return guess;
    }

    static int sqrtI(long val) {
        if (val <= 0L) {
            return 0;
        }
        long guess = 0L;
        long bit = 32768L;
        do {
            if ((guess ^= bit) * guess <= val) continue;
            guess ^= bit;
        } while ((bit >>= 1) != 0L);
        return (int)guess;
    }

    static int sqrt_x(int n) {
        int one;
        int op = n;
        int res = 0;
        for (one = 0x40000000; one > op; one >>= 2) {
        }
        while (one != 0) {
            if (op >= res + one) {
                op -= res + one;
                res += one << 1;
            }
            res >>= 1;
            one >>= 2;
        }
        return res;
    }

    static long sqrt_xx(long square) {
        long oldGuess;
        if (square <= 0L) {
            return 0L;
        }
        long guess = square;
        while ((guess = (oldGuess = guess) + square / oldGuess >> 1) < oldGuess && guess > 0L) {
        }
        return guess;
    }

    abstract void load(int var1);

    abstract void endAll();

    abstract void render();

    abstract void renderLoadingScreen();

    abstract void renderMenu();

    abstract boolean userSoft(int var1);

    abstract void drawMenuItem(int var1, String var2, int var3, int var4, int var5, int var6, int var7);

    abstract void userShift(int var1);

    abstract boolean postSelect(int var1);

    public boolean ninjaPaint() {
        if (System.currentTimeMillis() >= timeFrameEnd) {
            this.repaint();
            this.serviceRepaints();
            timeFrameEnd = System.currentTimeMillis() + 66L;
            return true;
        }
        return false;
    }

    static {
        COL_BACKGROUND = 0xFFFFFF;
        font1 = 0;
        font2 = 3;
        font3 = 6;
        font4 = 9;
        softKeyflags = 0;
        LINE_HEIGHT = 10;
        charWidths = new int[]{4, 1, 1, 5, 5, 9, 6, 1, 3, 3, 3, 5, 1, 3, 1, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 5, 5, 5, 5, 9, 7, 6, 6, 6, 5, 5, 7, 6, 1, 4, 6, 5, 7, 6, 7, 5, 7, 6, 6, 5, 6, 7, 9, 6, 7, 6, 2, 3, 2, 5, 0, 0, 5, 5, 5, 5, 5, 3, 5, 5, 1, 2, 4, 1, 7, 5, 5, 5, 5, 3, 5, 3, 5, 5, 7, 5, 10, 10, 3, 1, 3, 0, 0};
        tabStops = new int[]{28, 46, 64, 82, 100, 118, 136, 154, 172, 190};
        help = new String[]{"TEST HELP PAGE 1", "MY NAMER IS HElp PAGE 2", "WHY THANK YOU HELP PAGE 2, I ma just little help page 3."};
        strIntro = "Standard";
        SOFTKEY_HEIGHT = LINE_HEIGHT + 1;
        softs = new String[]{"", "Select", "Exit", "Back", "Pause", "Start", "Resume"};
        GAME_STATE = 0;
        saSounds = new String[]{"/Menu.mid", "/Game.mid", "/Whistle.mid", "/Cheer.mid"};
        font = 0;
        gameVars = new byte[]{0};
        saList = new String[0][];
        preExitState = 0;
        menuStack = new int[0];
        saMenu = new String[]{""};
        iaMenu = new int[]{0};
        iaRenderTypes = new int[]{0};
        totalVars = 0;
        menuStackPos = -1;
        bHorizMenu = false;
        sinetable = new int[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384};
        sinval = 0;
        cosval = 0;
    }
}

