/*
 * Decompiled with CFR 0.152.
 */
package zhang;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import zhang.GamePaint;
import zhang.GameRecord;
import zhang.GameSprite;
import zhang.GameTools;

public class GameTool {
    private final int TIME_PER_FRAME;
    final int WIDTH;
    final int HEIGHT;
    private int gameState = 20;
    private int menuState = 0;
    private int buttonState;
    private int mission;
    private boolean Alive = true;
    private int loadingCounter = 0;
    private final int GAME_LOAD;
    private final int GAME_SHOW_SCORE;
    private final int GAME_START;
    private final int GAME_RUN;
    private final int GAME_OVER;
    private final int GAME_PAUSE;
    private final int GAME_MENU;
    private final int MENU_MAIN;
    private final int MENU_OPTION;
    private final int MENU_HIGH_SCORE;
    private final int MENU_HELP;
    private final int MENU_ABOUT;
    private final int NEW_GAME_BUTTON;
    private final int HIGH_SCORE_BUTTON;
    private final int OPTION_BUTTON;
    private final int HELP_BUTTON;
    private final int ABOUT_BUTTON;
    private final int EXIT_BUTTON;
    private final int SOUND_ON;
    private final int SOUND_OFF;
    private final int BACK_BUTTON;
    final int ZERO_KEY;
    final int ONE_KEY;
    final int TWO_KEY;
    final int THREE_KEY;
    final int FOUR_KEY;
    final int FIVE_KEY;
    final int SIX_KEY;
    final int SEVEN_KEY;
    final int EIGHT_KEY;
    public final int NINE_KEY;
    final int UP_KEY;
    final int DOWN_KEY;
    final int LEFT_KEY;
    final int RIGHT_KEY;
    final int FIRE_KEY;
    final int LEFT_SOFT_KEY;
    final int RIGHT_SOFT_KEY;
    private GameTools gametools = new GameTools();
    private Image[][] menuImage;
    private Image[][] OptionImage;
    private Image integralImage;
    private Image[] playerImage;
    private Image[] impactImage;
    int loadCount = 0;
    int roleState = 0;
    int npcState = 0;
    private GamePaint gamePlayer;
    private GameSprite gameRun;
    private GameSprite[] gameNPC;
    protected boolean soundKey = true;
    private int sWitch = 0;
    Random random = new Random();
    int gameNPC_x;
    private int chinela_coordinate;
    private int gameover_x0;
    private int gameover_x1;
    GameRecord gameRecord;
    long starttime = 0L;
    long timetaken = 0L;

    public GameTool() {
        this.TIME_PER_FRAME = 100;
        this.WIDTH = 176;
        this.HEIGHT = 220;
        this.GAME_LOAD = 0;
        this.GAME_SHOW_SCORE = 10;
        this.GAME_START = 20;
        this.GAME_RUN = 30;
        this.GAME_OVER = 40;
        this.GAME_PAUSE = 50;
        this.GAME_MENU = 60;
        this.MENU_MAIN = 0;
        this.MENU_OPTION = 20;
        this.MENU_HIGH_SCORE = 10;
        this.MENU_HELP = 30;
        this.MENU_ABOUT = 40;
        this.NEW_GAME_BUTTON = 0;
        this.HIGH_SCORE_BUTTON = 1;
        this.OPTION_BUTTON = 2;
        this.HELP_BUTTON = 3;
        this.ABOUT_BUTTON = 4;
        this.EXIT_BUTTON = 5;
        this.SOUND_ON = 90;
        this.SOUND_OFF = 91;
        this.BACK_BUTTON = 92;
        this.ZERO_KEY = 48;
        this.ONE_KEY = 49;
        this.TWO_KEY = 50;
        this.THREE_KEY = 51;
        this.FOUR_KEY = 52;
        this.FIVE_KEY = 53;
        this.SIX_KEY = 54;
        this.SEVEN_KEY = 55;
        this.EIGHT_KEY = 56;
        this.NINE_KEY = 57;
        this.UP_KEY = -1;
        this.DOWN_KEY = -6;
        this.LEFT_KEY = -2;
        this.RIGHT_KEY = -5;
        this.FIRE_KEY = -20;
        this.LEFT_SOFT_KEY = -21;
        this.RIGHT_SOFT_KEY = -22;
        this.gamePlayer = new GamePaint();
        this.gameRecord = new GameRecord();
        this.gameRecord.readScore();
        this.gameInit();
    }

    private void gameInit() {
        switch (this.mission) {
            case 0: {
                this.menuImage = new Image[2][5];
                this.gametools.createImage(this.menuImage[0], "/zhangImg/Image.c", 3, 5);
                this.gametools.createImage(this.menuImage[1], "/zhangImg/Image.c", 8, 5);
                this.OptionImage = new Image[2][3];
                this.gametools.createImage(this.OptionImage[0], "/zhangImg/Image.c", 3, 3);
                this.gametools.createImage(this.OptionImage[1], "/zhangImg/Image.c", 8, 3);
                this.integralImage = this.gametools.createImage("/zhangImg/Image.c", 25);
                break;
            }
            case 1: {
                switch (this.loadCount) {
                    case 1: {
                        this.gameRun = new GameSprite();
                        this.playerImage = new Image[16];
                        this.gameNPC = new GameSprite[4];
                        this.gameover_x0 = -93;
                        this.gameover_x1 = 176;
                        break;
                    }
                    case 2: {
                        this.gametools.createImage(this.playerImage, "/zhangImg/Image.c", 13, 16);
                        break;
                    }
                    case 3: {
                        block16: for (int i = 0; i < this.gameNPC.length; ++i) {
                            this.gameNPC[i] = new GameSprite();
                            this.gameNPC_x = Math.abs(this.random.nextInt() % 3);
                            this.gameNPC[i].setX(18 + this.gameNPC_x * 33);
                            switch (i) {
                                case 0: {
                                    this.gameNPC[i].setY(-20);
                                    continue block16;
                                }
                                case 1: {
                                    if (this.gameNPC[i].getX() != this.gameNPC[i - 1].getX()) continue block16;
                                    this.gameNPC[i].setY(this.gameNPC[i - 1].getY() - 20);
                                    continue block16;
                                }
                                case 2: {
                                    if (this.gameNPC[i].getX() == this.gameNPC[i - 1].getX()) {
                                        this.gameNPC[i].setY(this.gameNPC[i - 1].getY() - 20);
                                    }
                                    if (this.gameNPC[i].getX() != this.gameNPC[i - 2].getX()) continue block16;
                                    this.gameNPC[i].setY(this.gameNPC[i - 2].getY() - 20);
                                    continue block16;
                                }
                                case 3: {
                                    if (this.gameNPC[i].getX() == this.gameNPC[i - 1].getX()) {
                                        this.gameNPC[i].setY(this.gameNPC[i - 1].getY() - 20);
                                    }
                                    if (this.gameNPC[i].getX() == this.gameNPC[i - 2].getX()) {
                                        this.gameNPC[i].setY(this.gameNPC[i - 2].getY() - 20);
                                    }
                                    if (this.gameNPC[i].getX() != this.gameNPC[i - 3].getX()) continue block16;
                                    this.gameNPC[i].setY(this.gameNPC[i - 3].getY() - 20);
                                    continue block16;
                                }
                            }
                        }
                        break;
                    }
                    case 4: {
                        this.impactImage = new Image[8];
                        this.gametools.createImage(this.impactImage, "/zhangImg/Image1.c", 0, 8);
                        this.gameRun.setImpactImage(this.impactImage);
                    }
                }
                break;
            }
        }
    }

    public void release() {
        this.impactImage = null;
        this.menuImage = null;
        this.OptionImage = null;
        this.menuImage = null;
        this.OptionImage = null;
        this.integralImage = null;
        this.playerImage = null;
        this.impactImage = null;
        System.gc();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        switch (this.gameState) {
            case 20: {
                this.gamePlayer.paint(graphics);
                break;
            }
            case 0: {
                ++this.loadingCounter;
                this.loadingCounter %= 5;
                this.gamePlayer.paintLoad(graphics, this.loadingCounter);
                break;
            }
            case 30: {
                int n;
                this.gameRun.paintGame(graphics, this.playerImage[0], this.playerImage[1], this.playerImage[2]);
                switch (this.roleState) {
                    case 0: {
                        for (n = 0; n < this.gameNPC.length; ++n) {
                            this.gameNPC[n].paintNPC(graphics, this.playerImage[5]);
                        }
                        break;
                    }
                    case 1: {
                        for (n = 0; n < this.gameNPC.length; ++n) {
                            this.gameNPC[n].paintNPC(graphics, this.playerImage[6]);
                        }
                        break;
                    }
                }
                for (n = 1; n < this.gameNPC.length; ++n) {
                    for (int i = 0; i < n; ++i) {
                        if (this.gameNPC[n].getX() != this.gameNPC[i].getX() || this.gameNPC[i].getY() >= 0 || this.gameNPC[n].getY() >= 0) continue;
                        this.gameNPC[n].setY(this.gameNPC[i].getY() - 20);
                    }
                }
                this.gameRun.paintMultiple(graphics, this.playerImage[3], this.playerImage[4]);
                this.gameRun.paintHPFlicker(graphics, this.roleState);
                this.gameRun.paitChinela(graphics, this.playerImage[7], this.playerImage[8], this.playerImage[9], this.npcState, this.chinela_coordinate);
                if (this.chinela_coordinate != 0) {
                    for (n = 0; n < this.gameNPC.length; ++n) {
                        this.gameNPC[n].isCollidingWith(this.chinela_coordinate);
                    }
                }
                this.chinela_coordinate = 0;
                this.npcState = 0;
                this.gameRun.paintCool(graphics);
                this.gameRun.paintIntegral(graphics, this.playerImage[11], this.roleState);
                this.gameRun.paintHP(graphics, this.playerImage[10]);
                this.gameRun.paintTime(graphics, this.playerImage[12]);
                this.gameRun.paintPlayerIntegral(graphics, this.playerImage[13]);
                this.gameRun.paintWarnning(graphics, this.roleState);
                break;
            }
            case 60: {
                this.paintMenu(graphics);
                break;
            }
            case 40: {
                this.gameRun.paintGame(graphics, this.playerImage[0], this.playerImage[1], this.playerImage[2]);
                for (int i = 0; i < this.gameNPC.length; ++i) {
                    this.gameNPC[i].paintNPC(graphics, this.playerImage[5]);
                }
                this.gameRun.paitChinela(graphics, this.playerImage[5], this.playerImage[6], this.playerImage[7], this.npcState, this.chinela_coordinate);
                this.gameRun.paintGameOver(graphics, this.playerImage[14], this.playerImage[15], this.gameover_x0, this.gameover_x1);
                this.gameRun.paintMultiple(graphics, this.playerImage[7], this.playerImage[8]);
                this.gameRun.paintHP(graphics, this.playerImage[10]);
                this.gameRun.paintIntegral(graphics, this.playerImage[11], this.roleState);
                this.gameRun.paintTime(graphics, this.playerImage[12]);
                this.gameRun.paintPlayerIntegral(graphics, this.playerImage[13]);
                break;
            }
            case 50: {
                this.paintMenu(graphics);
                break;
            }
            case 10: {
                this.gamePlayer.paintShowScore(graphics);
                break;
            }
        }
    }

    private void paintMenu(Graphics graphics) {
        block0 : switch (this.gameState) {
            case 60: {
                switch (this.menuState) {
                    case 0: {
                        if (this.loadCount < 14) {
                            this.gamePlayer.paintMenuBackdrop(graphics, this.menuImage[1], this.sWitch, this.loadCount);
                        }
                        if (this.loadCount < 14) break block0;
                        this.gamePlayer.paintMenu(graphics, this.menuImage, this.buttonState);
                        break block0;
                    }
                    case 10: {
                        this.gamePlayer.paintHighScore(graphics, this.integralImage, this.buttonState);
                        break block0;
                    }
                    case 20: {
                        this.gamePlayer.paintOption(graphics, this.OptionImage, this.buttonState);
                        break block0;
                    }
                    case 30: {
                        this.gamePlayer.paintHelp(graphics);
                        break block0;
                    }
                    case 40: {
                        this.gamePlayer.paintAbout(graphics);
                        break block0;
                    }
                }
                break;
            }
            case 50: {
                switch (this.menuState) {
                    case 0: {
                        this.gamePlayer.paintPause(graphics, this.menuImage, this.buttonState);
                        break block0;
                    }
                    case 20: {
                        this.gamePlayer.paintOption(graphics, this.OptionImage, this.buttonState);
                        break block0;
                    }
                    case 30: {
                        this.gamePlayer.paintHelp(graphics);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void run() {
        switch (this.gameState) {
            case 20: {
                this.gameState = 60;
                break;
            }
            case 60: {
                ++this.loadCount;
                if (this.loadCount <= 14) break;
                this.loadCount = 14;
                break;
            }
            case 0: {
                ++this.loadCount;
                if (this.Alive) {
                    this.gameInit();
                } else {
                    this.release();
                }
                if (this.loadCount < 10) break;
                if (this.Alive) {
                    this.gameState = 30;
                    this.loadCount = 0;
                    break;
                }
                this.gameState = 60;
                this.Alive = true;
                break;
            }
            case 30: {
                ++this.roleState;
                if (this.roleState > 1) {
                    this.roleState = 0;
                }
                for (int i = 0; i < this.gameNPC.length; ++i) {
                    this.gameNPC[i].move();
                }
                this.gameRun.timecounter(100L);
                if (this.gameRun.getHP_Y() < 10) break;
                this.gameState = 40;
                break;
            }
            case 50: {
                ++this.loadCount;
                if (this.loadCount <= 12) break;
                this.loadCount = 12;
                break;
            }
            case 40: {
                ++this.loadCount;
                if (this.loadCount < 7) {
                    this.gameover_x0 += 20;
                    this.gameover_x1 -= 20;
                }
                if (this.loadCount != 7) break;
                break;
            }
        }
    }

    public int keyPressed(int n) {
        int n2 = 30;
        if (this.gameState == 30 && n >= 49 && n <= 57) {
            this.chinela_coordinate = n - 48;
            this.npcState = 1;
        }
        block0 : switch (n) {
            case -1: 
            case 50: {
                switch (this.gameState) {
                    case 60: {
                        --this.buttonState;
                        switch (this.menuState) {
                            case 0: {
                                if (this.buttonState >= 0) break block0;
                                this.buttonState = 5;
                                break block0;
                            }
                            case 10: {
                                if (this.buttonState >= 0) break block0;
                                this.buttonState = 4;
                                break block0;
                            }
                            case 20: {
                                if (this.buttonState >= 90) break block0;
                                this.buttonState = 92;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 50: {
                        --this.buttonState;
                        switch (this.menuState) {
                            case 0: {
                                if (this.buttonState == 0) {
                                    this.buttonState = 4;
                                    break block0;
                                }
                                this.buttonState = 0;
                                break block0;
                            }
                            case 20: {
                                if (this.buttonState >= 90) break block0;
                                this.buttonState = 92;
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case -6: 
            case 56: {
                switch (this.gameState) {
                    case 60: {
                        switch (this.menuState) {
                            case 0: {
                                if (this.buttonState <= 5) break block0;
                                this.buttonState = 0;
                                break block0;
                            }
                            case 10: {
                                if (this.buttonState <= 4) break block0;
                                this.buttonState = 0;
                                break block0;
                            }
                            case 20: {
                                if (this.buttonState <= 92) break block0;
                                this.buttonState = 90;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 50: {
                        switch (this.menuState) {
                            case 0: {
                                if (this.buttonState == 0) {
                                    this.buttonState = 4;
                                    break block0;
                                }
                                this.buttonState = 0;
                                break block0;
                            }
                            case 20: {
                                if (this.buttonState <= 92) break block0;
                                this.buttonState = 90;
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case -20: 
            case 53: {
                block32 : switch (this.gameState) {
                    case 20: {
                        this.gameState = 60;
                        break;
                    }
                    case 60: {
                        switch (this.menuState) {
                            case 0: {
                                switch (this.buttonState) {
                                    case 0: {
                                        this.gameState = 0;
                                        this.Alive = true;
                                        this.mission = 1;
                                        break block32;
                                    }
                                    case 1: {
                                        this.menuState = 10;
                                        this.gamePlayer.setPlayerIntegral(this.gameRecord.maxIntegral);
                                        this.buttonState = 0;
                                        break block32;
                                    }
                                    case 3: {
                                        this.menuState = 30;
                                        break block32;
                                    }
                                    case 2: {
                                        this.menuState = 20;
                                        this.buttonState = 90;
                                        break block32;
                                    }
                                    case 4: {
                                        this.menuState = 40;
                                        break block32;
                                    }
                                    case 5: {
                                        this.soundKey = false;
                                        this.release();
                                        break block32;
                                    }
                                }
                                break block32;
                            }
                            case 10: {
                                this.menuState = 0;
                                this.sWitch = Math.abs(this.random.nextInt() % 4);
                                this.buttonState = 0;
                                break block32;
                            }
                            case 20: {
                                switch (this.buttonState) {
                                    case 90: {
                                        this.soundKey = true;
                                        this.buttonState = 92;
                                        break block32;
                                    }
                                    case 91: {
                                        this.soundKey = false;
                                        this.buttonState = 92;
                                        break block32;
                                    }
                                    case 92: {
                                        this.menuState = 0;
                                        this.sWitch = Math.abs(this.random.nextInt() % 4);
                                        this.buttonState = 0;
                                        break block32;
                                    }
                                }
                                break block32;
                            }
                            case 30: {
                                this.menuState = 0;
                                this.sWitch = Math.abs(this.random.nextInt() % 4);
                                this.buttonState = 0;
                                break block32;
                            }
                            case 40: {
                                this.menuState = 0;
                                this.sWitch = Math.abs(this.random.nextInt() % 4);
                                this.buttonState = 0;
                                break block32;
                            }
                        }
                        break;
                    }
                    case 50: {
                        switch (this.menuState) {
                            case 0: {
                                switch (this.buttonState) {
                                    case 0: {
                                        this.gameState = 30;
                                        break block32;
                                    }
                                    case 4: {
                                        n2 = 90;
                                        this.soundKey = false;
                                        this.release();
                                        break block32;
                                    }
                                }
                                break block32;
                            }
                            case 20: {
                                switch (this.buttonState) {
                                    case 90: {
                                        this.soundKey = true;
                                        this.buttonState = 92;
                                        break block32;
                                    }
                                    case 91: {
                                        this.soundKey = false;
                                        this.buttonState = 92;
                                        break block32;
                                    }
                                    case 92: {
                                        this.menuState = 0;
                                        this.sWitch = Math.abs(this.random.nextInt() % 4);
                                        this.buttonState = 0;
                                        break block32;
                                    }
                                }
                                break block32;
                            }
                            case 30: {
                                this.menuState = 0;
                                this.sWitch = Math.abs(this.random.nextInt() % 4);
                                this.buttonState = 0;
                                break block32;
                            }
                        }
                        break;
                    }
                    case 40: {
                        this.gameState = 10;
                        int[] nArray = new int[4];
                        nArray = this.gameRun.getGameTime();
                        int[] nArray2 = new int[]{this.gameRun.getPlayerIntegral(), nArray[0] + nArray[1] * 10 + nArray[2] * 100 + nArray[3] * 1000, this.gameRun.getMaxLoadCount()};
                        this.gamePlayer.setPlayIntegral(nArray2);
                        if (!this.gameRecord.compare(nArray2)) break;
                        this.gameRecord.Compositor();
                        this.gameRecord.SaveNew();
                        break;
                    }
                    case 10: {
                        this.gameState = 60;
                        this.buttonState = 0;
                        this.gameRun.Replacement();
                        break;
                    }
                }
                this.loadCount = 0;
                break;
            }
            case -22: {
                switch (this.gameState) {
                    case 30: {
                        this.gameState = 50;
                        this.buttonState = 0;
                        break block0;
                    }
                }
                break;
            }
        }
        return n2;
    }

    public void keyReleased(int n) {
        switch (this.gameState) {
            case 30: {
                if (n == 0) break;
                this.chinela_coordinate = 0;
                this.npcState = 0;
                break;
            }
        }
    }
}

