/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class GVInputStream {
    public final boolean debug;
    public DataInputStream dataInputStream;

    public GVInputStream(InputStream src) {
        this.debug = false;
        this.dataInputStream = new DataInputStream(src);
    }

    public boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public short readShort() throws IOException {
        short b1 = this.dataInputStream.readByte();
        short b2 = this.dataInputStream.readByte();
        return (short)((b1 & 0xFF) << 0 | (b2 & 0xFF) << 8);
    }

    public int readInt() throws IOException {
        byte b1 = this.dataInputStream.readByte();
        byte b2 = this.dataInputStream.readByte();
        byte b3 = this.dataInputStream.readByte();
        byte b4 = this.dataInputStream.readByte();
        return (b1 & 0xFF) << 0 | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public int readBigInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public long readLong() throws IOException {
        long v1 = this.readInt();
        long v2 = this.readInt();
        return (v1 & 0xFFFFFFFFFFFFFFFFL) << 32 | v2 & 0xFFFFFFFFL;
    }

    public String readString() throws IOException {
        int len = this.readInt();
        byte[] byteArray = new byte[len];
        this.dataInputStream.read(byteArray, 0, len);
        String str = new String(byteArray, 0, len);
        byteArray = null;
        return str.trim();
    }

    public String readString(int len) throws IOException {
        byte[] byteArray = new byte[len];
        this.dataInputStream.read(byteArray, 0, len);
        String str = new String(byteArray, 0, len);
        byteArray = null;
        return str.trim();
    }

    public byte[] readData(int size) throws IOException {
        byte[] ret = new byte[size];
        this.dataInputStream.read(ret);
        return ret;
    }

    public void skip(int size) throws IOException {
        this.dataInputStream.skipBytes(size);
    }

    public Image readImage() throws IOException {
        short len = this.readShort();
        byte[] data = new byte[len];
        this.dataInputStream.read(data, 0, len);
        Image img = Image.createImage((byte[])data, (int)0, (int)len);
        data = null;
        return img;
    }

    public Image readImage(int len) throws IOException {
        byte[] data = new byte[len];
        this.dataInputStream.read(data, 0, len);
        Image img = Image.createImage((byte[])data, (int)0, (int)len);
        data = null;
        return img;
    }

    public void close() {
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
                this.dataInputStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean available() throws IOException {
        return this.dataInputStream.available() > 0;
    }
}

