/*
 * Decompiled with CFR 0.152.
 */
package zrong.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import zrong.main.MainCanvas;
import zrong.ui.UIManager;

public class SystemAPI {
    public static final int FIELD_OUT = 1;
    public static final int FIELD_IN = 2;
    public static final int FIELD_CROSS = 4;
    static Random random = new Random();

    public static int inField(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n > n5 && n2 > n6 && n + n3 < n5 + n7 && n2 + n4 < n6 + n8) {
            return 2;
        }
        if (n > n5 + n7 || n2 > n6 + n8 || n + n3 < n5 || n2 + n4 < n6) {
            return 1;
        }
        return 4;
    }

    public static int divEnter(int n, int n2) {
        return n / n2 + (n % n2 == 0 ? 0 : 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeInputStream(InputStream inputStream) {
        if (inputStream == null) return;
        try {
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Throwable throwable) {
            inputStream = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeDataInputSream(DataInputStream dataInputStream) {
        if (dataInputStream == null) return;
        try {
            try {
                dataInputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Throwable throwable) {
            dataInputStream = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeByteArrayInputStream(ByteArrayInputStream byteArrayInputStream) {
        if (byteArrayInputStream == null) return;
        try {
            try {
                byteArrayInputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Throwable throwable) {
            byteArrayInputStream = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeDataOutputStream(DataOutputStream dataOutputStream) {
        if (dataOutputStream == null) return;
        try {
            try {
                dataOutputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Throwable throwable) {
            dataOutputStream = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeByteArrayOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        if (byteArrayOutputStream == null) return;
        try {
            try {
                byteArrayOutputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Throwable throwable) {
            byteArrayOutputStream = null;
            throw throwable;
        }
    }

    public static void closeInputStream(ByteArrayInputStream byteArrayInputStream, DataInputStream dataInputStream) {
        SystemAPI.closeByteArrayInputStream(byteArrayInputStream);
        SystemAPI.closeDataInputSream(dataInputStream);
    }

    public static void closeOutputStream(ByteArrayOutputStream byteArrayOutputStream, DataOutputStream dataOutputStream) {
        SystemAPI.closeByteArrayOutputStream(byteArrayOutputStream);
        SystemAPI.closeDataOutputStream(dataOutputStream);
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void waitGame(long l) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            MainCanvas.getInstance().repaint();
            MainCanvas.getInstance().serviceRepaints();
            SystemAPI.sleep(100L);
        }
    }

    public static void sleepGame(long l) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l) {
            SystemAPI.sleep(100L);
        }
    }

    public static Image createImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public static boolean isStringAvisible(String string) {
        return string != null && !string.equals("");
    }

    public static byte[] getNumBytes(long l) {
        char[] cArray = String.valueOf(l).toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(cArray[n2] - 48);
            if (byArray[0] == -3) {
                byArray[0] = 19;
            }
            ++n2;
        }
        return byArray;
    }

    public static byte[] getNumBytes(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                byArray[n2] = (byte)(cArray[n2] - 48);
            } else if (cArray[n2] == '*') {
                byArray[n2] = 17;
            } else if (cArray[n2] == ',') {
                byArray[n2] = 13;
            } else if (cArray[n2] == ':') {
                byArray[n2] = 14;
            } else if (cArray[n2] == '\u4ebf') {
                byArray[n2] = 12;
            } else if (cArray[n2] == '\u4e07') {
                byArray[n2] = 11;
            }
            ++n2;
        }
        return byArray;
    }

    public static String getNumString(long l) {
        String string = String.valueOf(l);
        char[] cArray = string.toCharArray();
        if (cArray.length <= 0) {
            return null;
        }
        int n = cArray.length / 3 - (cArray.length % 3 == 0 ? 1 : 0);
        char[] cArray2 = new char[cArray.length + n];
        int n2 = cArray2.length - 1;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (n3 != 0 && n3 % 3 == 0) {
                cArray2[n2] = 44;
                --n2;
            }
            cArray2[n2] = cArray[cArray.length - 1 - n3];
            --n2;
            ++n3;
        }
        return new String(cArray2);
    }

    public static String[][] readStringIndex(String string) {
        try {
            DataInputStream dataInputStream = null;
            String[][] stringArray = new String[2][];
            dataInputStream = SystemAPI.createInputStream(dataInputStream, string);
            if (dataInputStream != null) {
                int n = dataInputStream.readInt();
                stringArray[0] = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[0][n2] = dataInputStream.readUTF();
                    ++n2;
                }
                int n3 = dataInputStream.readInt();
                stringArray[1] = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    stringArray[1][n4] = dataInputStream.readUTF();
                    ++n4;
                }
            }
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String[] readStringPackage(String string) {
        try {
            DataInputStream dataInputStream = null;
            String[] stringArray = null;
            dataInputStream = SystemAPI.createInputStream(dataInputStream, string);
            if (dataInputStream != null) {
                int n = dataInputStream.readInt();
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = dataInputStream.readUTF();
                    ++n2;
                }
            }
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static DataInputStream createInputStream(DataInputStream dataInputStream, String string) {
        InputStream inputStream = null;
        inputStream = string.getClass().getResourceAsStream("/" + string);
        if (inputStream != null) {
            dataInputStream = new DataInputStream(inputStream);
        }
        return dataInputStream;
    }

    public static boolean runIsPoint(int n, int n2, int n3, int n4) {
        boolean bl;
        if (UIManager.peekIsPointerPressed(n, n2, n3, n4) && (bl = SystemAPI.IsPtInPoly(UIManager.getEventX(), UIManager.getEventY(), new int[][]{{n, n2 + (n4 >> 1)}, {n + (n3 >> 1), n2 + n4}, {n + n3, n2 + (n4 >> 1)}, {n + (n3 >> 1), n2}}))) {
            UIManager.setEvent(null);
            return true;
        }
        return false;
    }

    public static boolean IsPtInPoly(int n, int n2, int[][] nArray) {
        if (nArray == null || nArray.length <= 2) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (n4 == nArray.length - 1) {
                n9 = nArray[n4][0];
                n8 = nArray[n4][1];
                n7 = nArray[0][0];
                n6 = nArray[0][1];
            } else {
                n9 = nArray[n4][0];
                n8 = nArray[n4][1];
                n7 = nArray[n4 + 1][0];
                n6 = nArray[n4 + 1][1];
            }
            if ((n2 >= n8 && n2 < n6 || n2 >= n6 && n2 < n8) && Math.abs(n8 - n6) > 0 && (n5 = n9 - (n8 - n2) * (n9 - n7) / (n8 - n6)) < n) {
                ++n3;
            }
            ++n4;
        }
        return n3 % 2 != 0;
    }

    public static int getShortArrayIndex(short[] sArray, short s) {
        if (sArray == null) {
            return -1;
        }
        int n = 0;
        while (n < sArray.length) {
            if (sArray[n] == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getIntArrayIndex(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int getByteArrayIndex(byte[] byArray, byte by) {
        if (byArray == null) {
            return -1;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getLongArrayIndex(long[] lArray, byte by) {
        if (lArray == null) {
            return -1;
        }
        int n = 0;
        while (n < lArray.length) {
            if (lArray[n] == (long)by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getStringArrayIndex(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return -1;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null && object != null && objectArray[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static byte getByteArrayValue(byte[] byArray, int n) {
        if (byArray == null) {
            return -1;
        }
        if (n >= 0 && n < byArray.length) {
            return byArray[n];
        }
        return -1;
    }

    public static short getShortArrayValue(short[] sArray, int n) {
        if (sArray == null) {
            return -1;
        }
        if (n >= 0 && n < sArray.length) {
            return sArray[n];
        }
        return -1;
    }

    public static int getIntArrayValue(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        if (n >= 0 && n < nArray.length) {
            return nArray[n];
        }
        return -1;
    }

    public static long getLongArrayValue(long[] lArray, int n) {
        if (lArray == null) {
            return -1L;
        }
        if (n >= 0 && n < lArray.length) {
            return lArray[n];
        }
        return -1L;
    }

    public static String getStringArrayValue(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        if (n >= 0 && n < stringArray.length) {
            return stringArray[n];
        }
        return null;
    }

    public static Object getObjectArrayValue(Object[] objectArray, int n) {
        if (objectArray == null) {
            return null;
        }
        if (n >= 0 && n < objectArray.length) {
            return objectArray[n];
        }
        return null;
    }

    public static String[] split(String string, String string2) {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        int n2 = 0;
        if (string != null) {
            n = string.indexOf(string2);
            while (n < string.length() && n != -1) {
                String string3 = string.substring(n2, n);
                vector.addElement(string3);
                n2 = n + string2.length();
                n = string.indexOf(string2, n + string2.length());
            }
            vector.addElement(string.substring(n2 + 1 - string2.length()));
            stringArray = new String[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                stringArray[n3] = (String)vector.elementAt(n3);
                ++n3;
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static boolean keyWord_in_arrory(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && string.indexOf(stringArray[n]) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int getRandom(int n, int n2) {
        int n3 = random.nextInt();
        n3 = Math.abs(n3 % n2) + n;
        return n3;
    }
}

